<?php
    
    use artbox\core\helpers\ImageHelper;
    use artbox\order\models\Order;
    use yii\helpers\Url;
    use yii\web\View;
    
    /**
     * @var View  $this
     * @var Order $order
     */
    
    $this->params[ 'breadcrumbs' ][] = [
        'label' => \Yii::t('app', 'Заказы'),
        'url'   => [
            'account/index',
        ],
    ];
    $this->params[ 'breadcrumbs' ][] = \Yii::t('app', 'Заказ') . ' № ' . $order->id;

?>

<div id="content">
  <div class="container">
    
    <div class="row">
      
      <!-- *** LEFT COLUMN ***
_________________________________________________________ -->
      
      <div class="col-md-9 clearfix" id="customer-order">
        
        <p class="lead">Заказ №<?= $order->id ?> был перемещён на <strong><?= date(
                    'd.m.Y',
                    $order->created_at
                ) ?></strong><?php
                if (!empty($order->label)) {
                    ?> и в данный момент
                  <strong><?= $order->label->lang->title ?></strong>.<?php } ?></p>
        <p class="lead text-muted">Если у вас есть вопросы, пожалуйста,
          <a target="_blank" href="<?= Url::to(
              [ 'site/contact' ]
          ) ?>">напишите нам</a>.</p>
        
        <div class="box">
          <div class="table-responsive">
            <table class="table">
              <thead>
                <tr>
                  <th colspan="2">Товар</th>
                  <th>Количество</th>
                  <th>Цена за единицу</th>
                  <th>Всего</th>
                </tr>
              </thead>
              <tbody>
                  <?php
                      $total = 0;
                      foreach ($order->orderProducts as $product) {
                          $total += $product->price * $product->count;
                          ?>
                        <tr>
                          <td>
                            <a target="_blank" href="<?= Url::to(
                                [
                                    'product/view',
                                    'id' => $product->variant->product->id,
                                ]
                            ) ?>">
                                <?= ImageHelper::set(
                                    $product->variant ? $product->variant->product->image->getPath(
                                    ) : '@frontend/web/img/no-image.png'
                                )
                                               ->cropResize(50, 50)
                                               ->renderImage(
                                                   [
                                                       'alt' => $product->variant->product->lang->title,
                                                   ]
                                               ) ?>
                            </a>
                          </td>
                          <td><a target="_blank" href="<?= Url::to(
                                  [
                                      'product/view',
                                      'id' => $product->variant->product->id,
                                  ]
                              ) ?>"><?= $product->variant->product->lang->title ?></a>
                          </td>
                          <td><?= $product->count ?></td>
                          <td><?= $product->price ?></td>
                          <td><?= $product->count * $product->price ?></td>
                        </tr>
                      <?php } ?>
              </tbody>
              <tfoot>
                <tr>
                  <th colspan="4" class="text-right">Всего</th>
                  <th><?= $total ?></th>
                </tr>
              </tfoot>
            </table>
          
          </div>
          <!-- /.table-responsive -->
          
          <div class="row addresses">
            <div class="col-sm-6 col-sm-offset-6">
              <h3 class="text-uppercase"><?= \Yii::t('app', 'Информация') ?></h3>
              <p><?= $order->name ?>
                <br><?= $order->phone ?>
                <br><?= $order->city ?>
                <br><?= $order->address ?>
                <br><?= $order->payment->lang->title ?>
                <br><?= $order->delivery->lang->title ?></p>
            </div>
          </div>
          <!-- /.addresses -->
        
        </div>
        <!-- /.box -->
      
      </div>
      <!-- /.col-md-9 -->
      
      <!-- *** LEFT COLUMN END *** -->
      
      <!-- *** RIGHT COLUMN ***
_________________________________________________________ -->
      
      <div class="col-md-3">
        <!-- *** CUSTOMER MENU ***
_________________________________________________________ -->
          <?= $this->render('_menu') ?>
        <!-- /.col-md-3 -->
        
        <!-- *** CUSTOMER MENU END *** -->
      </div>
      
      <!-- *** RIGHT COLUMN END *** -->
    
    </div>
    <!-- /.row -->
  
  
  </div>
  <!-- /.container -->
</div>
<!-- /#content -->
            
      