<?php
    
    use artbox\order\models\Order;
    use yii\helpers\Url;
    use yii\web\View;
    
    /**
     * @var View    $this
     * @var Order[] $orders
     */
    
    $this->params[ 'breadcrumbs' ][] = \Yii::t('app', 'Мои заказы');

?>

<div id="content">
  <div class="container">
    
    
    <div class="row">
      
      <!-- *** LEFT COLUMN ***
_________________________________________________________ -->
      
      <div class="col-md-9" id="customer-orders">
        
        <p class="text-muted lead">Если у вас есть вопросы, пожалуйста,
          <a href="contact.html">напишите нам</a>, наш центр обслуживания клиентов работает круглосуточно.</p>
        
        <div class="box">
          
          <div class="table-responsive">
            <table class="table table-hover">
              <thead>
                <tr>
                  <th>Заказ</th>
                  <th>Дата</th>
                  <th>Сумма</th>
                  <th>Статус</th>
                  <th>Действие</th>
                </tr>
              </thead>
              <tbody>
                  
                  <?php foreach ($orders as $order) {
                      $price = 0;
                      foreach ($order->orderProducts as $product) {
                          $price += $product->price * $product->count;
                      }
                      ?>
                    <tr>
                      <th>№<?= $order->id; ?></th>
                      <td><?= date('d.m.Y', $order->created_at); ?></td>
                      <td><?= $price ?></td>
                        <?php if (empty($order->label)) { ?>
                          <td><span class="label label-info">Не задан</span>
                          </td>
                            <?php
                        } else { ?>
                          <td>
                            <span style="background-color:<?= $order->label->color ?>" class="label label-info"><?= $order->label->lang->title ?></span>
                          </td>
                        <?php }
                        ?>
                      <td><a href="<?= Url::to(
                              [
                                  'account/order',
                                  'id' => $order->id,
                              ]
                          ) ?>" class="btn btn-template-main btn-sm">Посмотреть</a>
                      </td>
                    </tr>
                  <?php } ?>
              
              </tbody>
            </table>
          </div>
          <!-- /.table-responsive -->
        
        </div>
        <!-- /.box -->
      
      </div>
      <!-- /.col-md-9 -->
      
      <!-- *** LEFT COLUMN END *** -->
      
      <!-- *** RIGHT COLUMN ***
_________________________________________________________ -->
      
      <div class="col-md-3">
        <!-- *** CUSTOMER MENU ***
_________________________________________________________ -->
          <?= $this->render('_menu'); ?>
        <!-- /.col-md-3 -->
        
        <!-- *** CUSTOMER MENU END *** -->
      </div>
      
      <!-- *** RIGHT COLUMN END *** -->
    
    </div>
  
  
  </div>
  <!-- /.container -->
</div>
<!-- /#content -->
            
       