<?php
    
    use artbox\order\models\Customer;
    use artbox\order\models\PasswordForm;
    use kartik\date\DatePicker;
    use yii\helpers\Html;
    use yii\web\View;
    use yii\widgets\ActiveForm;
    
    /**
     * @var View         $this
     * @var PasswordForm $passwordModel
     * @var Customer     $userModel
     */
    
    $this->params[ 'breadcrumbs' ][] = \Yii::t('app', 'Мой аккаунт');

?>

<div id="content">
  
  <div class="container">
    
    <div class="row">
      
      <!-- *** LEFT COLUMN ***
_________________________________________________________ -->
      
      <div class="col-md-9 clearfix" id="customer-account">
        
        <p class="lead">Измените ваши персональные данные или пароль здесь.</p>
        
        <div class="box">
          
          <div class="heading">
            <h3 class="text-uppercase">Изменить пароль</h3>
          </div>
            
            <?php $passwordForm = ActiveForm::begin(
                [
                    'action' => [ 'account/change-password' ],
                ]
            ) ?>
          <div class="row">
            <div class="col-sm-6">
                <?= $passwordForm->field($passwordModel, 'oldpass')
                                 ->passwordInput() ?>
            </div>
          </div>
          <div class="row">
            <div class="col-sm-6">
                <?= $passwordForm->field($passwordModel, 'newpass')
                                 ->passwordInput() ?>
            </div>
            <div class="col-sm-6">
                <?= $passwordForm->field($passwordModel, 'repeatnewpass')
                                 ->passwordInput() ?>
            </div>
          </div>
          <!-- /.row -->
          
          <div class="text-center">
              <?= Html::submitButton(
                  '<i class="fa fa-save"></i> Сохранить новый пароль',
                  [ 'class' => 'btn btn-template-main' ]
              ) ?>
          </div>
            <?php $passwordForm::end(); ?>
        
        </div>
        <!-- /.box -->
        
        
        <div class="box clearfix">
          <div class="heading">
            <h3 class="text-uppercase">Персональные данные</h3>
          </div>
    
            <?php $userForm = ActiveForm::begin(
                [
                    'action' => [ 'account/change-data' ],
                ]
            ) ?>
          <div class="row">
            <div class="col-sm-6">
                <?= $userForm->field($userModel, 'name') ?>
            </div>
            <div class="col-sm-6">
                <?= $userForm->field($userModel, 'address')
                             ->textInput() ?>
            </div>
          </div>
          <!-- /.row -->
  
          <div class="row">
            <div class="col-sm-6 col-md-3">
                <?= $userForm->field($userModel, 'city')
                             ->textInput() ?>
            </div>
            <div class="col-sm-6 col-md-3">
                <?= $userForm->field($userModel, 'gender')
                             ->dropDownList(
                                 [
                                     1 => \Yii::t('app', 'Муж.'),
                                     2 => \Yii::t('app', 'Жен.'),
                                 ],
                                 [
                                     'prompt' => \Yii::t('app', 'Пол'),
                                 ]
                             ) ?>
            </div>
            <div class="col-sm-6 col-md-6">
                <?= $userForm->field($userModel, 'email')
                             ->textInput() ?>
            </div>
  
          </div>
          <div class="row">
    
            <div class="col-sm-6">
                <?= $userForm->field($userModel, 'phone')
                             ->textInput() ?>
    
            </div>
            <div class="col-sm-6">
                <?= $userForm->field($userModel, 'birthDate')
                             ->widget(
                                 DatePicker::className(),
                                 [
                                     'options'       => [
                                         'placeholder' => \Yii::t('app', 'Дата рождения ...'),
                                     ],
                                     'pluginOptions' => [
                                         'autoclose' => true,
                                         'format'    => 'dd.mm.yyyy',
                                     ],
                                 ]
                             ) ?>
            </div>
            <div class="col-sm-12 text-center">
                <?= Html::submitButton(
                    '<i class="fa fa-save"></i> Сохранить изменения',
                    [
                        'class' => 'btn btn-template-main',
                    ]
                ) ?>
            </div>
          </div>
    
            <?php $userForm::end(); ?>
        
        </div>
      
      </div>
      <!-- /.col-md-9 -->
      
      <!-- *** LEFT COLUMN END *** -->
      
      <!-- *** RIGHT COLUMN ***
_________________________________________________________ -->
      
      <div class="col-md-3">
        <!-- *** CUSTOMER MENU ***
_________________________________________________________ -->
          <?= $this->render('_menu') ?>
        <!-- /.col-md-3 -->
        
        <!-- *** CUSTOMER MENU END *** -->
      </div>
      
      <!-- *** RIGHT COLUMN END *** -->
    
    </div>
    <!-- /.row -->
  
  </div>
  <!-- /.container -->
</div>
<!-- /#content -->
    