<?php
    
    use artbox\catalog\models\Variant;
    use artbox\core\helpers\ImageHelper;
    use yii\helpers\Html;
    use yii\helpers\Url;
    use yii\web\View;
    
    /**
     * @var View    $this
     * @var Variant $model
     */

?>

<div class="col-md-3 col-sm-4">
  <div class="product">
    <div class="image">
      <a href="<?= Url::to(
          [
              'product/view',
              'id' => $model->product->id,
          ]
      ) ?>">
          <?= Html::a(
              Html::tag(
                  'i',
                  '',
                  [
                      'class' => 'fa fa-close',
                  ]
              ),
              '#',
              [
                  'class' => 'wishlist-delete',
                  'data'  => [
                      'user'    => \Yii::$app->user->identity->getId(),
                      'variant' => $model->id,
                      'product' => $model->product->id,
                      'url'     => Url::to([ 'account/wishlist-delete' ]),
                  ],
              ]
          ) ?>
          <?= ImageHelper::set(
              empty($model->product->image) ? '@frontend/web/img/no-image.png' : $model->product->image->getPath()
          )
                         ->cropResize(190, 190)
                         ->renderImage(
                             [
                                 'class' => 'img-responsive image1',
                             ]
                         ) ?>
      </a>
    </div>
    <!-- /.image -->
    <div class="text">
      <h3><a href="<?= Url::to(
              [
                  'product/view',
                  'id' => $model->product->id,
              ]
          ) ?>"><?= $model->product->lang->title ?></a></h3>
      <p class="price">Цена: <?= $model->price ?> грн.</p>
      <p class="buttons">
          <?php
              if ($model->canBuy()) {
                  echo Html::a(
                      Html::tag(
                          'i',
                          '',
                          [
                              'class' => 'fa fa-shopping-cart',
                          ]
                      ) . \Yii::t('app', 'В корзину'),
                      '#',
                      [
                          'class'   => 'btn btn-template-main add-to-basket',
                          'data-id' => $model->id,
                      ]
                  );
              } else {
                  echo Html::a(
                      \Yii::t('app', 'Нет в наличии'),
                      '#',
                      [
                          'class'   => 'btn btn-info disabled',
                          'data-id' => $model->id,
                      ]
                  );
              }
          ?>
      </p>
    </div>
    <!-- /.text -->
      <?php if ($model->product->is('akcia')) { ?>
      
        <div class="ribbon sale">
          <div class="theribbon">АКЦИЯ</div>
          <div class="ribbon-background"></div>
        </div>
        <!-- /.ribbon -->
      <?php } ?>
    
      <?php if ($model->product->is('new')) { ?>
      
        <div class="ribbon new">
          <div class="theribbon">НОВОЕ</div>
          <div class="ribbon-background"></div>
        </div>
        <!-- /.ribbon -->
      <?php } ?>
    
    
      <?php if ($model->product->is('top')) { ?>
        <div class="ribbon top">
          <div class="theribbon">ТОП</div>
          <div class="ribbon-background"></div>
        </div>
        <!-- /.ribbon -->
      <?php } ?>
  
  </div>
  <!-- /.product -->
</div>
