<?php
    
    namespace frontend\models;

    use artbox\catalog\models\Variant;
    use artbox\order\models\Delivery;
    use artbox\order\models\Payment;
    use yii\behaviors\BlameableBehavior;
    
    class Order extends \artbox\order\models\Order
    {
        public $variantId;
        public $returnUrl;
    
        const SCENARIO_INFO = 'info';
        const SCENARIO_DELIVERY = 'delivery';
        const SCENARIO_PAYMENT = 'payment';
        const SCENARIO_CONFIRM = 'confirm';
        const SCENARIO_FAST = 'fast';
    
        /**
         * @inheritdoc
         */
        public function scenarios()
        {
            return array_merge(
                parent::scenarios(),
                [
                    self::SCENARIO_INFO     => [
                        'name',
                        'phone',
                        'email',
                        'city',
                        'address',
                        'comment',
                    ],
                    self::SCENARIO_DELIVERY => [
                        'delivery_id',
                    ],
                    self::SCENARIO_PAYMENT  => [
                        'payment_id',
                    ],
                    self::SCENARIO_FAST     => [
                        'name',
                        'phone',
                        'variantId',
                        'returnUrl',
                    ],
                ]
            );
        }
    
        public function behaviors()
        {
            $behaviors = parent::behaviors();
            $behaviors[] = [
                'class'              => BlameableBehavior::className(),
                'createdByAttribute' => 'user_id',
                'updatedByAttribute' => false,
            ];
            return $behaviors;
        }
        
        /**
         * @inheritdoc
         */
        public function rules()
        {
            return [
                [
                    [
                        'name',
                        'phone',
                        'email',
                        'delivery_id',
                        'payment_id',
                    ],
                    'required',
                ],
                [
                    [
                        'name',
                        'phone',
                        'email',
                        'city',
                        'address',
                    ],
                    'string',
                    'max' => 255,
                ],
                [
                    [
                        'comment',
                        'returnUrl',
                    ],
                    'string',
                ],
                [
                    [
                        'delivery_id',
                        'payment_id',
                    ],
                    'integer',
                ],
                [
                    [
                        'delivery_id',
                    ],
                    'exist',
                    'targetClass'     => Delivery::className(),
                    'targetAttribute' => 'id',
                ],
                [
                    [
                        'payment_id',
                    ],
                    'exist',
                    'targetClass'     => Payment::className(),
                    'targetAttribute' => 'id',
                ],
                [
                    [
                        'variantId',
                    ],
                    'exist',
                    'targetClass'     => Variant::className(),
                    'targetAttribute' => 'id',
                    'filter'          => function ($query) {
                        /**
                         * @var \yii\db\Query $query
                         */
                        $query->andWhere(
                            [
                                '>',
                                'price',
                                0,
                            ]
                        )
                              ->andWhere([ 'status' => true ])
                              ->andWhere(
                                  [
                                      '>',
                                      'stock',
                                      0,
                                  ]
                              );
                    },
                    'on'              => self::SCENARIO_FAST,
                ],
                [
                    [
                        'variantId',
                    ],
                    'required',
                    'on' => self::SCENARIO_FAST,
                ],
            ];
        }
    
        /**
         * Save active attributes to session variable 'order'
         */
        public function saveActive()
        {
            $order = \Yii::$app->session->get('order', []);
            foreach ($this->activeAttributes() as $attribute) {
                $order[ $attribute ] = $this->getAttribute($attribute);
            }
            \Yii::$app->session[ 'order' ] = $order;
        }
    
        /**
         * Load active attributes from session variable 'order'
         */
        public function loadActive()
        {
            $order = \Yii::$app->session->get('order');
            if (!empty($order)) {
                foreach ($this->activeAttributes() as $attribute) {
                    if (!empty($order[ $attribute ])) {
                        $this->setAttribute($attribute, $order[ $attribute ]);
                    }
                }
            }
        }
    }