<?php
    
    namespace frontend\controllers;
    
    use artbox\catalog\models\Variant;
    use artbox\core\components\SeoComponent;
    use yii\db\ActiveQuery;
    use yii\web\Controller;
    use yii\web\NotFoundHttpException;
    use Yii;
    
    /**
     * Class VariantController
     *
     * @package frontend\controllers
     */
    class VariantController extends Controller
    {
        /**
         * Show product by ID
         *
         * @param int $id
         *
         * @return string
         */
        public function actionView($id)
        {
            $model = $this->findModel($id);
            /**
             * @var \artbox\catalog\components\History $history
             */
            if ($history = \Yii::$app->get('history', false)) {
                $history->add($model->id);
            }
            /**
             * @var SeoComponent $seo
             */
            $seo = Yii::$app->get('seo');
            $seo->setModel($model->lang);
            $groups = $model->getSortedGroups();
            $similar = $model->product->getSimilarProducts(8);
            
            return $this->render(
                'view',
                [
                    'model'   => $model,
                    'groups'  => $groups,
                    'similar' => $similar,
                ]
            );
        }
        
        /**
         * Find variant by ID
         *
         * @param $id
         *
         * @return \artbox\catalog\models\Variant
         * @throws \yii\web\NotFoundHttpException
         */
        protected function findModel($id)
        {
            /**
             * @var SeoComponent $seo
             */
            $seo = \Yii::$app->get('seo');
            /**
             * @var Variant $model
             */
            $model = Variant::findWithFilters()
                            ->with('lang', 'image')
                            ->with(
                                [
                                    'product' => function ($query) {
                                        /**
                                         * @var ActiveQuery $query
                                         */
                                        $query->with('images')
                                              ->with(
                                                  [
                                                      'category' => function ($query) {
                                                          /**
                                                           * @var ActiveQuery $query
                                                           */
                                                          $query->with('lang')
                                                                ->with('parent.lang');
                                                      },
                                                  ]
                                              );
                                    },
                                ]
                            )
                            ->where([ 'id' => $id ])
                            ->one();
            if (!empty($model)) {
                if ($model->lang->alias_id !== $seo->aliasId) {
                    throw new NotFoundHttpException(\Yii::t('app', 'Wrong language'));
                }
                return $model;
            } else {
                throw new NotFoundHttpException(\Yii::t('app', 'Model not found'));
            }
        }
    }