<?php
    
    namespace frontend\controllers;
    
    use artbox\catalog\models\Category;
    use artbox\catalog\models\Product;
    use yii\data\ActiveDataProvider;
    use yii\web\Controller;
    use yii\web\NotFoundHttpException;
    
    /**
     * Class SpecialController
     *
     * @package frontend\controllers
     */
    class SpecialController extends Controller
    {
        /**
         * Show all specials by type
         *
         * @param string $type
         *
         * @return string
         */
        public function actionIndex($type)
        {
            $query = Category::find()
                             ->with('lang.alias')
                             ->innerJoinWith('products', false)
                             ->groupBy('category.id');
            if ($type === 'new') {
                $query->is('product.mask', 2);
                $productQuery = Product::find()
                                       ->is('product.mask', 2);
            } else {
                $query->is('product.mask', 4);
                $productQuery = Product::find()
                                       ->is('product.mask', 4);
            }
            $categories = $query->all();
            $dataProvider = new ActiveDataProvider(
                [
                    'query' => $productQuery,
                ]
            );
            return $this->render(
                'index',
                [
                    'categories'   => $categories,
                    'dataProvider' => $dataProvider,
                ]
            );
        }
        
        /**
         * Show specials by type and category
         *
         * @param $type
         * @param $category
         *
         * @return string
         */
        public function actionCategory($type, $category)
        {
            $model = $this->findCategory($category);
            $query = Product::find()
                            ->with('variants', 'image')
                            ->innerJoinWith('categories', 'false')
                            ->where([ 'product_to_category.category_id' => $model->id ])
                            ->orderBy(
                                [
                                    'product.sort'       => SORT_ASC,
                                    'product.created_at' => SORT_DESC,
                                ]
                            );
            if ($type === 'new') {
                $query->is('product.mask', 2);
            } elseif ($type === 'sale') {
                $query->is('product.mask', 4);
            }
            $dataProvider = new ActiveDataProvider(
                [
                    'query' => $query,
                ]
            );
            return $this->render(
                'category',
                [
                    'model'        => $model,
                    'dataProvider' => $dataProvider,
                ]
            );
        }
        
        /**
         * @param string $category
         *
         * @return Category
         * @throws \yii\web\NotFoundHttpException
         */
        protected function findCategory(string $category)
        {
            /**
             * @var Category $model
             */
            $model = Category::find()
                             ->innerJoinWith('lang.alias', false)
                             ->where([ 'alias.value' => $category ])
                             ->one();
            if (!empty($model)) {
                return $model;
            } else {
                throw new NotFoundHttpException('Model not found');
            }
        }
    }