<?php
    
    namespace frontend\controllers;
    
    use artbox\catalog\models\Category;
    use common\models\SearchForm;
    use yii\data\ActiveDataProvider;
    use yii\web\Controller;
    use yii\web\NotFoundHttpException;
    
    class SearchController extends Controller
    {
        public function actionIndex($word = '')
        {
            $searchForm = new SearchForm(
                [
                    'word' => $word,
                ]
            );
            $dataProvider = null;
            $categories = [];
            if ($searchForm->validate()) {
                $dataProvider = new ActiveDataProvider(
                    [
                        'query' => $searchForm->search(),
                    ]
                );
                /**
                 * @var \artbox\catalog\models\queries\ProductQuery $categoryQuery
                 */
                $categoryQuery = clone $dataProvider->query;
                $categoryQuery->select([ 'product.id' ]);
                $categories = Category::find()
                                      ->active()
                                      ->with('lang')
                                      ->joinWith('productToCategories')
                                      ->andWhere([ 'product_to_category.product_id' => $categoryQuery->column() ])
                                      ->all();
            }
            return $this->render(
                'index',
                [
                    'searchForm'   => $searchForm,
                    'dataProvider' => $dataProvider,
                    'categories'   => $categories,
                ]
            );
        }
        
        public function actionCategory($categoryId, $word = '')
        {
            /**
             * @var Category $category
             */
            $category = Category::find()
                                ->active()
                                ->andWhere([ 'id' => $categoryId ])
                                ->with('lang')
                                ->one();
            if (!$category) {
                throw new NotFoundHttpException(\Yii::t('app', 'Category not found!'));
            }
            $searchForm = new SearchForm(
                [
                    'word' => $word,
                ]
            );
            $dataProvider = null;
            $categories = [];
            if ($searchForm->validate()) {
                /**
                 * @var \artbox\catalog\models\queries\ProductQuery $query
                 */
                $query = $searchForm->search();
                /**
                 * @var \artbox\catalog\models\queries\ProductQuery $categoryQuery
                 */
                $categoryQuery = clone $query;
                $dataProvider = new ActiveDataProvider(
                    [
                        'query' => $searchForm->searchCategory($category, $query),
                    ]
                );
                $categoryQuery->select([ 'product.id' ]);
                $categories = Category::find()
                                      ->active()
                                      ->joinWith('productToCategories')
                                      ->andWhere([ 'product_to_category.product_id' => $categoryQuery->column() ])
                                      ->all();
            }
            return $this->render(
                'category',
                [
                    'searchForm'   => $searchForm,
                    'dataProvider' => $dataProvider,
                    'categories'   => $categories,
                    'category'     => $category,
                ]
            );
        }
    }