<?php
    
    namespace frontend\controllers;
    
    use artbox\catalog\models\Product;
    use artbox\core\components\SeoComponent;
    use artbox\order\models\Wishlist;
    use yii\db\ActiveQuery;
    use yii\helpers\Html;
    use yii\helpers\Url;
    use yii\web\Controller;
    use yii\web\NotFoundHttpException;
    use yii\web\Response;
    
    /**
     * Class ProductController
     *
     * @package frontend\controllers
     */
    class ProductController extends Controller
    {
        /**
         * Show product by ID
         *
         * @param int $id
         *
         * @return string
         * @throws \yii\web\NotFoundHttpException
         */
        public function actionView($id)
        {
            $model = Product::find()
                            ->with('variant')
                            ->where([ 'id' => $id ])
                            ->one();
            if (!$model || empty($model->variant)) {
                throw new NotFoundHttpException('Product not found');
            }
            return $this->redirect(
                [
                    'variant/view',
                    'id' => $model->variant->id,
                ]
            );
            //Uncomment to have product page
            //            $model = $this->findModel($id);
            //            /**
            //             * @var SeoComponent $seo
            //             */
            //            $seo = Yii::$app->get('seo');
            //            $seo->setModel($model->lang);
            //            $variant = $model->variants[ 0 ];
            //            $groups = $variant->getSortedGroups();
            //            $similar = $model->getSimilarProducts(8);
            //
            //            return $this->render(
            //                'view',
            //                [
            //                    'model'   => $model,
            //                    'variant' => $variant,
            //                    'groups'  => $groups,
            //                    'similar' => $similar,
            //                ]
            //            );
        }
        
        /**
         * Find product by ID
         *
         * @param $id
         *
         * @return Product
         * @throws \yii\web\NotFoundHttpException
         */
        protected function findModel($id)
        {
            /**
             * @var SeoComponent $seo
             */
            $seo = \Yii::$app->get('seo');
            /**
             * @var Product $model
             */
            $model = Product::findWithFilters()
                            ->with('lang', 'images', 'image')
                            ->with(
                                [
                                    'category' => function ($query) {
                                        /**
                                         * @var ActiveQuery $query
                                         */
                                        $query->with('lang')
                                              ->with('parent.lang');
                                    },
                                ]
                            )
                            ->where([ 'id' => $id ])
                            ->one();
            if (!empty($model)) {
                if ($model->lang->alias_id !== $seo->aliasId) {
                    throw new NotFoundHttpException(\Yii::t('app', 'Wrong language'));
                }
                return $model;
            } else {
                throw new NotFoundHttpException(\Yii::t('app', 'Model not found'));
            }
        }
    
        /**
         * Remove product from wishlist
         *
         * @return array
         */
        public function actionWishlistRm()
        {
            \Yii::$app->response->format = Response::FORMAT_JSON;
            if (\Yii::$app->request->isPost) {
                $model = Wishlist::find()
                                 ->where(
                                     [
                                         'user_id' => \Yii::$app->request->post('user'),
                                     ]
                                 )
                                 ->andWhere(
                                     [
                                         'variant_id' => \Yii::$app->request->post('variant'),

                                     ]
                                 )
                                 ->one();
                if (!empty($model) && $model->delete()) {
                    return [
                        'button'  => Html::button(
                            Html::tag('i', '', [ 'class' => 'fa fa-heart-o' ]),
                            [
                                'title' => \Yii::t('app', 'Добавить в избранное'),
                                'data'  => [
                                    'toggle'    => 'tooltip',
                                    'placement' => 'top',
                                    'product'   => \Yii::$app->request->post('product'),
                                    'variant'   => \Yii::$app->request->post('variant'),
                                    'user'      => \Yii::$app->request->post('user'),
                                    'url'       => Url::to([ 'product/wishlist-add' ]),
                                ],
                                'class' => 'wishlist-add btn btn-success pull-right',
                            ]
                        ),
                        'message' => \Yii::t('app', 'Товар убран из избранного'),
                    ];
                }
    
                return [
                    'button'  => Html::button(
                        Html::tag('i', '', [ 'class' => 'fa fa-heart' ]),
                        [
                            'title' => \Yii::t('app', 'Убрать из избранного'),
                            'data'  => [
                                'toggle'    => 'tooltip',
                                'placement' => 'top',
                                'product'   => \Yii::$app->request->post('product'),
                                'variant'   => \Yii::$app->request->post('variant'),
                                'user'      => \Yii::$app->request->post('user'),
                                'url'       => Url::to([ 'product/wishlist-rm' ]),
                            ],
                            'class' => 'wishlist-rm btn btn-success pull-right',
                        ]
                    ),
                    'message' => \Yii::t('app', 'Товар не найден'),
                ];
            }
            return [];
        }
    
        /**
         * Add product to wishlist
         *
         * @return array
         */
        public function actionWishlistAdd()
        {
            \Yii::$app->response->format = Response::FORMAT_JSON;
            if (\Yii::$app->request->isPost) {
                $model = new Wishlist();
                $model->user_id = \Yii::$app->request->post('user');
                $model->variant_id = \Yii::$app->request->post('variant');
                $model->product_id = \Yii::$app->request->post('product');
    
                if ($model->save()) {
                    return [
                        'button'  => Html::button(
                            Html::tag('i', '', [ 'class' => 'fa fa-heart' ]),
                            [
                                'title' => \Yii::t('app', 'Убрать из избранного'),
                                'data'  => [
                                    'toggle'    => 'tooltip',
                                    'placement' => 'top',
                                    'product'   => \Yii::$app->request->post('product'),
                                    'variant'   => \Yii::$app->request->post('variant'),
                                    'user'      => \Yii::$app->request->post('user'),
                                    'url'       => Url::to([ 'product/wishlist-rm' ]),
                                ],
                                'class' => 'wishlist-rm btn btn-success pull-right',
                            ]
                        ),
                        'message' => 'Товар добавлен в избранное',
                    ];
                }
    
                return [
                    'button'  => Html::button(
                        Html::tag('i', '', [ 'class' => 'fa fa-heart-o' ]),
                        [
                            'title' => \Yii::t('app', 'Добавить в избранное'),
                            'data'  => [
                                'toggle'    => 'tooltip',
                                'placement' => 'top',
                                'product'   => \Yii::$app->request->post('product'),
                                'variant'   => \Yii::$app->request->post('variant'),
                                'user'      => \Yii::$app->request->post('user'),
                                'url'       => Url::to([ 'product/wishlist-add' ]),
                            ],
                            'class' => 'wishlist-add btn btn-success pull-right',
                        ]
                    ),
                    'message' => \Yii::t('app', 'Товар добавить не вышло'),
                ];
            }
            return [];
        }
    }