<?php
    namespace frontend\controllers;
    
    use artbox\core\components\SeoComponent;
    use artbox\core\models\Page;
    use yii\web\Controller;
    use yii\web\NotFoundHttpException;
    use Yii;
    
    /**
     * Class PageController
     *
     * @package frontend\controllers
     */
    class PageController extends Controller
    {
        public function actionView($id)
        {
            $model = $this->findModel($id);
            
            /**
             * @var SeoComponent $seo
             */
            $seo = Yii::$app->get('seo');
            $seo->setModel($model->lang);
            
            $pages = Page::find()
                         ->with('lang')
                         ->where(
                             [
                                 'not',
                                 [ 'id' => $id ],
                             ]
                         )
                         ->limit(5)
                         ->all();
            
            return $this->render(
                'view',
                [
                    'model' => $model,
                    'pages' => $pages,
                ]
            );
        }
    
        /**
         * @param $id
         *
         * @return \artbox\core\models\Page
         * @throws \yii\web\NotFoundHttpException
         */
        protected function findModel($id)
        {
            /**
             * @var Page $model
             */
            $model = Page::find()
                         ->where(
                             [
                                 'id' => $id,
                             ]
                         )
                         ->with('lang')
                         ->one();
            
            if (!empty( $model )) {
                if ($model->lang->alias_id !== Yii::$app->seo->aliasId) {
                    throw new NotFoundHttpException(\Yii::t('app', 'Wrong language'));
                }
                return $model;
            } else {
                throw new NotFoundHttpException(\Yii::t('app', 'Model not found'));
            }
        }
    }