<?php
    namespace frontend\controllers;
    
    use artbox\catalog\helpers\FilterHelper;
    use artbox\catalog\models\Category;
    use yii\data\ActiveDataProvider;
    use yii\web\Controller;
    use yii\web\NotFoundHttpException;
    
    /**
     * Class FilterController
     */
    class FilterController extends Controller
    {
        public function actionIndex($filter, $category_id)
        {
            $category = $this->findCategory($category_id);
            /**
             * @var FilterHelper $filterHelper
             */
            $filterHelper = \Yii::$app->get('filter');
            $filterHelper->setFilter($filter);
            $query = $filterHelper->buildQuery();
            $dataProvider = new ActiveDataProvider(
                [
                    'query' => $query,
                ]
            );
            return $this->render(
                'index',
                [
                    'dataProvider' => $dataProvider,
                    'category'     => $category,
                ]
            );
        }
        
        protected function findCategory($id)
        {
            if ($model = Category::findWithFilters($id)
                                 ->one()
            ) {
                return $model;
            } else {
                throw new NotFoundHttpException();
            }
        }
    }