<?php
    
    namespace frontend\controllers;
    
    use artbox\weblog\models\Article;
    use artbox\weblog\models\Category;
    use artbox\weblog\models\Tag;
    use yii\data\ActiveDataProvider;
    use yii\web\Controller;
    use yii\web\NotFoundHttpException;
    
    /**
     * Class BlogController
     *
     * @package frontend\controllers
     */
    class BlogController extends Controller
    {
        public function actionIndex($q = '')
        {
            $tags = Tag::find()
                       ->with(
                           [
                               'lang',
                           ]
                       )
                       ->all();
            $dataProvider = new ActiveDataProvider(
                [
                    'query'      => Article::find()
                                           ->orderBy(
                                               [
                                                   'created_at' => SORT_DESC,
                                               ]
                                           )
                                           ->joinWith(
                                               [
                                                   'lang',
                                                   'categories.lang',
                                               ]
                                           )
                                           ->andFilterWhere(
                                               [
                                                   'like',
                                                   'blog_article_lang.title',
                                                   $q,
                                               ]
                                           ),
                    'pagination' => [
                        'pageSize' => 3,
                    ],
                ]
            );
            
            return $this->render(
                'index',
                [
                    'tags'         => $tags,
                    'dataProvider' => $dataProvider,
                ]
            );
        }
    
        public function actionArticle($id)
        {
            $model = $this->findModel($id);
    
            $tags = Tag::find()
                       ->with([ 'lang' ])
                       ->all();
    
            return $this->render(
                'view',
                [
                    'tags'  => $tags,
                    'model' => $model,
                ]
            );
        }
    
        public function actionCategory($id)
        {
            $tags = Tag::find()
                       ->with(
                           [
                               'lang',
                           ]
                       )
                       ->all();
    
            /**
             * @var Category $model
             */
            $model = Category::find()
                             ->where(
                                 [
                                     'id' => $id,
                                 ]
                             )
                             ->with(
                                 [
                                     'articles',
                                 ]
                             )
                             ->one();
    
            $dataProvider = new ActiveDataProvider(
                [
                    'query'      => $model->getArticles()
                                          ->with(
                                              [
                                                  'lang',
                                                  'categories.lang',
                                              ]
                                          )
                                          ->orderBy(
                                              [
                                                  'created_at' => SORT_DESC,
                                              ]
                                          ),
                    'pagination' => [
                        'pageSize' => 3,
                    ],
                ]
            );
    
            return $this->render(
                'category',
                [
                    'tags'         => $tags,
                    'dataProvider' => $dataProvider,
                    'model'        => $model,
                ]
            );
        }
    
        public function actionTag($id)
        {
            $tags = Tag::find()
                       ->with(
                           [
                               'lang',
                           ]
                       )
                       ->all();
    
            /**
             * @var Category $model
             */
            $model = Tag::find()
                        ->where(
                            [
                                'id' => $id,
                            ]
                        )
                        ->with(
                            [
                                'articles',
                            ]
                        )
                        ->one();
    
            $dataProvider = new ActiveDataProvider(
                [
                    'query'      => $model->getArticles()
                                          ->with(
                                              [
                                                  'lang',
                                                  'categories.lang',
                                              ]
                                          )
                                          ->orderBy(
                                              [
                                                  'created_at' => SORT_DESC,
                                              ]
                                          ),
                    'pagination' => [
                        'pageSize' => 3,
                    ],
                ]
            );
    
            return $this->render(
                'tag',
                [
                    'tags'         => $tags,
                    'dataProvider' => $dataProvider,
                    'model'        => $model,
                ]
            );
        }
    
        /**
         * @param $id
         *
         * @return Article
         * @throws \yii\web\NotFoundHttpException
         */
        protected function findModel($id)
        {
            /**
             * @var Article | null $model
             */
            $model = Article::find()
                            ->where([ 'id' => $id ])
                            ->with(
                                [
                                    'lang',
                                    'categories.lang',
                                    'tags.lang',
                                ]
                            )
                            ->one();
    
            if (empty($model)) {
                throw new NotFoundHttpException(\Yii::t('app', 'Article not found'));
            } else {
                return $model;
            }
        }
    }