<?php
    use artbox\catalog\components\History;
    use artbox\core\components\LanguageRequest;
    use artbox\core\components\SeoUrlManager;
    use artbox\order\models\Basket;
    
    $params = array_merge(
        require( __DIR__ . '/../../common/config/params.php' ),
        require( __DIR__ . '/../../common/config/params-local.php' ),
        require( __DIR__ . '/params.php' ),
        require( __DIR__ . '/params-local.php' )
    );
    
    return [
        'id'                  => 'app-frontend',
        'homeUrl'             => '/',
        'basePath'            => dirname(__DIR__),
        'bootstrap'           => [
            'log',
            'assetsAutoCompress',
        ],
        'controllerNamespace' => 'frontend\controllers',
        'controllerMap'       => [
            'basket' => 'artbox\order\controllers\BasketController',
        ],
        'components'          => [
            'request'            => [
                'class'     => LanguageRequest::className(),
                'csrfParam' => '_csrf-frontend',
                'baseUrl'   => '/',
            ],
            'user'               => [
                'identityClass'   => 'artbox\order\models\Customer',
                'enableAutoLogin' => true,
                'identityCookie'  => [
                    'name'     => '_identity-frontend',
                    'httpOnly' => true,
                ],
            ],
            'session'            => [
                // this is the name of the session cookie used for login on the frontend
                'name' => 'advanced-frontend',
            ],
            'log'                => [
                'traceLevel' => YII_DEBUG ? 3 : 0,
                'targets'    => [
                    [
                        'class'  => 'yii\log\FileTarget',
                        'levels' => [
                            'error',
                            'warning',
                        ],
                    ],
                    [
                        'class'      => 'yii\log\FileTarget',
                        'logFile'    => '@frontend/runtime/logs/eauth.log',
                        'categories' => [
                            'nodge\eauth\*',
                        ],
                        'logVars'    => [],
                    ],
                ],
            ],
            'errorHandler'       => [
                'errorAction' => 'site/error',
            ],
            'urlManager'         => [
                'baseUrl'         => '/',
                'class'           => SeoUrlManager::className(),
                'enablePrettyUrl' => true,
                'showScriptName'  => false,
                'forceRedirect'   => true,
                'rules'           => [
                    [
                        'pattern'  => 'filter/<filter>',
                        'route'    => 'filter/index',
                        'defaults' => [ 'filter' => '' ],
                    ],
                    [
                        'pattern'  => 'category/<category>/<filter>',
                        'route'    => 'category/view',
                        'defaults' => [ 'filter' => '' ],
                    ],
                    'special/<type:(new|sale)>'                                                                     => 'special/index',
                    'special/<category>/<type:(new|sale)>'                                                          => 'special/category',
                    'robots.txt'                                                                                    => 'site/robots',
                    [
                        'pattern'  => 'artbox-comment/manage/<action>',
                        'route'    => 'notfound',
                        'defaults' => [
                            'action' => '',
                        ],
                    ],
                    'login/<service:google|twitter|facebook|yahoo|linkedin|linkedin_oauth2|github|steam|instagram>' => 'site/login',
                ],
            ],
            'basket'             => [
                'class' => Basket::className(),
            ],
            'eauth'              => require( 'eauth.php' ),
            'history'            => [
                'class' => History::className(),
            ],
            'assetsAutoCompress' => [
                'class'   => '\skeeks\yii2\assetsAuto\AssetsAutoCompressComponent',
                'enabled' => false,
            ],
        ],
        'params'              => $params,
    ];
