<?php
    
    namespace frontend\assets;
    
    use yii\web\AssetBundle;
    
    /**
     * Main frontend application asset bundle.
     */
    class AppAsset extends AssetBundle
    {
        public $basePath = '@webroot';
        public $baseUrl = '@web';
        public $css = [
            'css/animate.css',
            'css/style.css',
            'css/owl.carousel.css',
            'css/owl.theme.css',
            '//fonts.googleapis.com/css?family=Roboto:400,100,100italic,300,300italic,500,700,800',
            'css/custom.css',
            'css/perfect-scrollbar.min.css',
        ];
        public $js = [
            'js/jquery.cookie.js',
            'js/waypoints.min.js',
            'js/jquery.counterup.min.js',
            'js/jquery.parallax-1.1.3.js',
            'js/front.js',
            'js/owl.carousel.min.js',
            'js/perfect-scrollbar.min.js',
            'js/ion.rangeSlider.min.js',
            'js/script.js',
        ];
        public $depends = [
            'hiqdev\assets\pnotify\PNotifyAsset',
            'yii\web\YiiAsset',
            'rmrevin\yii\fontawesome\AssetBundle',
            'yii\bootstrap\BootstrapPluginAsset',
            'yii\widgets\PjaxAsset',
            'artbox\order\assets\BasketAsset',
        ];
    }
    