<?php
    /**
     * Created by PhpStorm.
     * User: yarik
     * Date: 12.06.17
     * Time: 14:07
     */
    
    namespace console\controllers;
    
    use artbox\catalog\models\Product;
    use artbox\odoo\components\Builder;
    use artbox\odoo\components\OdooHelper;
    use artbox\odoo\components\Query;
    use artbox\odoo\models\OdooToOrder;
    use artbox\odoo\models\OdooToProduct;
    use artbox\order\models\Order;
    use Ripcord\Ripcord;
    use yii\console\Controller;
    
    class TestController extends Controller
    {
        public function actionIndex()
        {
            $url = 'https://demo.cloudbank.biz';
            $db = 'odoo';
            $username = 'admin';
            $password = 'htcge,kbrf';
            $info = Ripcord::client("$url/xmlrpc/2/common");
            $uid = call_user_func_array(
                [
                    $info,
                    'authenticate',
                ],
                [
                    $db,
                    $username,
                    $password,
                    [],
                ]
            );
            $modelsQuery = Ripcord::client("$url/xmlrpc/2/object");
            $models = call_user_func_array(
                [
                    $modelsQuery,
                    'execute_kw',
                ],
                [
                    $db,
                    $uid,
                    $password,
                    'product.template',
                    'search_read',
                    [ [] ],
                    [ 'fields' => [ 'name' ] ],
                ]
            );
            var_dump($models);
        }
        
        public function actionT()
        {
            /**
             * @var \artbox\odoo\components\Connection $odoo
             */
            $odoo = \Yii::$app->get('odoo');
            
            /**
             * @var \artbox\odoo\components\Connection $connection
             */
            $result = $odoo->createCommand(
                'product.template',
                'search_read',
                [
                    [
                        [
                            'list_price',
                            '=',
                            10,
                        ],
                    ],
                ],
                [
                    'fields' => [
                        'name',
                        'list_price',
                    ],
                ]
            )
                           ->execute();
            var_dump($result);
        }
        
        public function actionK()
        {
            /**
             * @var \artbox\odoo\components\Connection $odoo
             */
            $odoo = \Yii::$app->get('odoo');
            
            $result = $odoo->createCommand(
                'product.template',
                'create',
                [
                    [
                        'name' => 'Test10',
                    ],
                ]
            )
                           ->execute();
            var_dump($result);
        }
        
        public function actionQ()
        {
            /**
             * @var \artbox\odoo\components\Connection $odoo
             * @var \artbox\odoo\components\OdooMapper $mapper
             */
            $odoo = \Yii::$app->get('odoo');
            $mapper = \Yii::$app->get('odooMapper');
            $result = ( new Query() )->from('product.template')
                                     ->where(
                                         [
                                             'id',
                                             '=',
                                             3,
                                         ]
                                     )
                                     ->one();
            $mapped = $mapper->toArtbox($result);
            var_dump($mapped);
            die();
            var_dump($mapper->toOdoo($mapped));
        }
        
        public function actionW()
        {
            /**
             * @var \artbox\odoo\components\Connection $odoo
             * @var \artbox\odoo\components\OdooMapper $mapper
             */
            $odoo = \Yii::$app->get('odoo');
            $mapper = \Yii::$app->get('odooMapper');
            $result = ( new Query() )->from('sale.order')
                                     ->where(
                                         [
                                             'id',
                                             '=',
                                             1,
                                         ]
                                     )
                                     ->one();
            $products = ( new Query() )->from('sale.order.line')
                                       ->where(
                                           [
                                               'order_id',
                                               '=',
                                               $result[ 'id' ],
                                           ]
                                       )
                                       ->all();
            foreach ($products as $product) {
                var_dump($mapper->toArtbox($product));
            }
        }
        
        public function actionE()
        {
            /**
             * @var \artbox\odoo\components\Connection $odoo
             */
            $odoo = \Yii::$app->get('odoo');
            $builder = new Builder($odoo);
            $userId = $builder->setParam('name', 'Test1')
                              ->create('res.partner')
                              ->execute();
            $command = $builder->setParam('name', 'Test123')
                               ->setParam('partner_id', $userId)
                               ->create('sale.order');
            var_dump($command->execute());
        }
        
        public function actionR()
        {
            /**
             * @var Order $order
             */
            $order = Order::find()
                          ->with('orderProducts.variant.product')
                          ->one();
            $odooHelper = new OdooHelper();
            $odooHelper->ensureSaleOrderLine($order);
        }
    }