<?php
    use artbox\catalog\helpers\FilterHelper;
    use artbox\core\components\AliasCache;
    use artbox\core\components\SeoComponent;
    use artbox\odoo\components\OdooMapper;
    
    return [
        'vendorPath' => dirname(dirname(__DIR__)) . '/vendor',
        'modules'    => [
            'imagemanager'   => [
                'class'                => 'artbox\core\components\imagemanager\Module',
                'canUploadImage'       => true,
                'canRemoveImage'       => function () {
                    return true;
                },
                'setBlameableBehavior' => false,
                'cssFiles'             => [
                    'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.6.3/css/font-awesome.min.css',
                ],
            ],
            'artbox-comment' => [
                'class'             => 'artbox\webcomment\Module',
                'enablePremoderate' => false,
            ],
        ],
        'components' => [
            'cache'        => [
                'class' => 'yii\caching\FileCache',
            ],
            'i18n'         => [
                'translations' => [
                    'core'           => [
                        'class'    => 'yii\i18n\PhpMessageSource',
                        'basePath' => '@artbox/core/messages',
                    ],
                    'catalog'        => [
                        'class'    => 'yii\i18n\PhpMessageSource',
                        'basePath' => '@artbox/catalog/messages',
                    ],
                    'app'            => [
                        'class'    => 'yii\i18n\PhpMessageSource',
                        'basePath' => '@common/messages',
                    ],
                    'blog'           => [
                        'class'    => 'yii\i18n\PhpMessageSource',
                        'basePath' => '@artbox/weblog/messages',
                    ],
                    'order'          => [
                        'class'    => 'yii\i18n\PhpMessageSource',
                        'basePath' => '@artbox/order/messages',
                    ],
                    'artbox-comment' => [
                        'class'    => 'yii\i18n\PhpMessageSource',
                        'basePath' => '@artbox/webcomment/messages',
                    ],
                    'eauth'          => [
                        'class'    => 'yii\i18n\PhpMessageSource',
                        'basePath' => '@eauth/messages',
                    ],
                    'odoo'           => [
                        'class'    => 'yii\i18n\PhpMessageSource',
                        'basePath' => '@artbox/odoo/messages',
                    ],
                    'imagemanager'   => [
                        'class'    => 'yii\i18n\PhpMessageSource',
                        'basePath' => '@artbox/core/components/imagemanager/messages',
                    ],
                ],
            ],
            'filedb'       => [
                'class' => 'yii2tech\filedb\Connection',
                'path'  => '@common/config',
            ],
            'sitemapdb'    => [
                'class'          => 'yii2tech\filedb\Connection',
                'path'           => '@common/config',
                'primaryKeyName' => 'id',
            ],
            'seo'          => [
                'class' => SeoComponent::className(),
            ],
            'filter'       => [
                'class' => FilterHelper::className(),
            ],
            'imagemanager' => [
                'class'       => 'artbox\core\components\imagemanager\components\ImageManagerGetPath',
                'mediaPath'   => dirname(dirname(__DIR__)) . '/storage',
                'cachePath'   => '../../storage/cache',
                'useFilename' => true,
                'absoluteUrl' => false,
            ],
            'aliasCache'   => [
                'class' => AliasCache::className(),
            ],
        ],
    ];
