$(
    function() {
        $.ajax(
            {
                url: "/admin/ajax/analytics",
                type: "POST",
                success: function(data) {
                    // Replacing top data
                    $('#sessions')
                        .animateNumber({number: data.sessions}, 2000);
                    $('#users')
                        .animateNumber({number: data.users}, 2000);
                    $('#views')
                        .animateNumber({number: data.views}, 2000);
                    $('#newusers')
                        .animateNumber({number: data.newusers}, 2000);
                    // Building main chart
                    var chart = AmCharts.makeChart(
                        "chartdiv", {
                            "type": "serial",
                            "startDuration": 1,
                            "startEffect": "elastic",
                            'dataProvider': data.plot,
                            'categoryField': 'day',
                            'categoryAxis': {
                                'labelFrequency': 5
                            },
                            'graphs': [
                                {
                                    'balloon': {
                                        "drop": true,
                                        "adjustBorderColor": false,
                                        "color": "#FFFFFF"
                                    },
                                    "bullet": "round",
                                    "bulletBorderAlpha": 1,
                                    "bulletColor": "#FFFFFF",
                                    "bulletSize": 5,
                                    "hideBulletsCount": 50,
                                    "lineThickness": 2,
                                    "title": "red line",
                                    "useLineColorForBulletBorder": true,
                                    "valueField": "users",
                                    "balloonText": "<span style='font-size:18px;'>Users: [[users]]</span>",
                                    "lineColor": '#9ABCC3'
                                },
                                {
                                    'balloon': {
                                        "drop": true,
                                        "adjustBorderColor": false,
                                        "color": "#ffffff"
                                    },
                                    "bullet": "round",
                                    "bulletBorderAlpha": 1,
                                    "bulletColor": "#FFFFFF",
                                    "bulletSize": 5,
                                    "hideBulletsCount": 50,
                                    "lineThickness": 2,
                                    "title": "red line",
                                    "useLineColorForBulletBorder": true,
                                    "valueField": "sessions",
                                    "balloonText": "<span style='font-size:18px;'>Sessions: [[sessions]]</span>",
                                    "lineColor": '#A8E3D6'
                                }
                            ],
                            'chartCursor': {
                                "pan": true,
                                "valueLineEnabled": true,
                                "valueLineBalloonEnabled": true,
                                "cursorAlpha": 1,
                                "cursorColor": "#1ABB9C",
                                "limitToGraph": "g1",
                                "valueLineAlpha": 0.2,
                                "valueZoomable": true
                            }
                        }
                    );

                    // Building pie chart
                    var pie = AmCharts.makeChart(
                        "piediv", {
                            "type": "pie",
                            'dataProvider': data.pie,
                            "titleField": "category",
                            "valueField": "column-1",
                            'colors': [
                                "#A8E3D6",
                                "#9ABCC3"
                            ],
                            "labelRadius": 5,

                            "radius": "42%",
                            "innerRadius": "60%",
                            "labelText": "[[title]]",
                        }
                    );
                    // Replacing table stabs
                    $('#browsers')
                        .replaceWith(data.browsers);
                    $('#cities')
                        .replaceWith(data.cityes);
                    $('#countries')
                        .replaceWith(data.countries);
                    $('.yt-loader')
                        .remove();
                }
            }
        )
    }
);

