<?php
    use common\models\SitemapDynamic;
    use common\models\SitemapStatic;
    use yii\bootstrap\ActiveForm;
    use yii\bootstrap\Html;
    use yii\helpers\Url;
    use yii\web\View;
    use yiister\gentelella\widgets\Panel;
    
    /**
     * @var View             $this
     * @var SitemapStatic[]  $models
     * @var SitemapDynamic[] $entity_models
     */
    $this->params[ 'breadcrumbs' ][] = [
        'label' => \Yii::t('core', 'Sitemap'),
        'url'   => [ 'index' ],
    ];
    $this->title = \Yii::t('core', 'Update sitemap');
    $this->params[ 'breadcrumbs' ][] = $this->title;
    $form = ActiveForm::begin();
    $xPanel = Panel::begin(
        [
            'header'      => \Yii::t('core', 'Static pages'),
            'collapsable' => true,
            'options'     => [
                'class' => 'x_panel dynamic_fields',
            ],
        ]
    );
    foreach ($models as $index => $model) {
        echo Html::tag(
            'div',
            $form->field(
                $model,
                "[$index]url",
                [
                    'options' => [
                        'class' => 'form-group col-xs-5 col-sm-6',
                    ],
                ]
            )
                 ->textInput() . $form->field(
                $model,
                "[$index]frequency",
                [
                    'options' => [
                        'class' => 'form-group col-xs-3 col-sm-3',
                    ],
                ]
            )
                                      ->dropDownList(
                                          [
                                              'always'  => 'постоянно',
                                              'hourly'  => 'ежечасно',
                                              'daily'   => 'ежедневно',
                                              'weekly'  => 'еженедельно',
                                              'monthly' => 'ежемесячно',
                                              'yearly'  => 'ежегодно',
                                              'never'   => 'никогда',
                                          ]
                                      ) . $form->field(
                $model,
                "[$index]priority",
                [
                    'options' => [
                        'class' => 'form-group col-xs-3 col-sm-2',
                    ],
                ]
            )
                                               ->textInput() . Html::icon(
                'minus',
                [
                    'class'   => 'col-xs-1 field-group-remove',
                    'onclick' => 'sitemap_remove(this)',
                ]
            ),
            [
                'class' => 'row field-group',
            ]
        );
    }
    echo Html::button(
        \Yii::t('core', 'Add field'),
        [
            'class'   => 'btn btn-default',
            'onclick' => 'sitemap_add(this)',
            'data'    => [
                'url' => Url::to([ 'create-static' ]),
            ],
        ]
    );
    $xPanel::end();
    $xPanel2 = Panel::begin(
        [
            'header'      => \Yii::t('core', 'Dynamic pages'),
            'collapsable' => true,
        ]
    );
?>
    <div class="col-xs-9 col-sm-10"></div>
    <div class="col-xs-3 col-sm-2 text-center"><?php echo $entity_models[ 0 ]->getAttributeLabel('priority'); ?></div>
    <div class="clearfix"></div>
<?php
    foreach ($entity_models as $index => $entity_model) {
        ?>
        <div class="form-group col-xs-6 col-sm-8">
            <?php
                echo Html::tag(
                    'div',
                    Html::activeInput(
                        'text',
                        $entity_model,
                        "[$index]entity",
                        [
                            'class'    => 'form-control',
                            'readonly' => 1,
                        ]
                    ) . Html::tag(
                        'span',
                        Html::activeCheckbox(
                            $entity_model,
                            "[$index]status",
                            [
                                'label' => false,
                            ]
                        ),
                        [
                            'class' => 'input-group-addon',
                        ]
                    ),
                    [
                        'class' => 'input-group',
                    ]
                );
            ?>
        </div>
        <div class="form-group col-xs-3 col-sm-2">
            <?php
                echo $form->field($entity_model, "[$index]frequency")
                          ->label(false)
                          ->dropDownList(
                              [
                                  'always'  => 'постоянно',
                                  'hourly'  => 'ежечасно',
                                  'daily'   => 'ежедневно',
                                  'weekly'  => 'еженедельно',
                                  'monthly' => 'ежемесячно',
                                  'yearly'  => 'ежегодно',
                                  'never'   => 'никогда',
                              ]
                          );
            ?>
        </div>
        <div class="form-group col-xs-3 col-sm-2">
            <?php
                echo $form->field($entity_model, "[$index]priority")
                          ->label(false)
                          ->input(
                              'number',
                              [
                                  'step' => 0.1,
                                  'min'  => 0,
                                  'max'  => 1,
                              ]
                          );
            ?>
        </div>
        <?php
    }
    $xPanel2::end();
    echo Html::submitButton(
        \Yii::t('core', 'Save'),
        [
            'class' => 'btn btn-success',
        ]
    );
    echo Html::submitButton(
        \Yii::t('core', 'Save and generate'),
        [
            'class' => 'btn btn-primary',
            'name'  => 'action',
            'value' => 'generate',
        ]
    );
    $form::end();
    $js = <<<JS
    function sitemap_add(e) {
        var url = $(e)
            .data('url');
        var form_id = $(e)
            .parents('form')
            .attr('id');
        var form = $('#' + form_id);
        var count = $('.field-group').length;
        $.get(
            url, {
                'formId': form_id,
                'count': count
            }, function(data) {
                form.find('.field-group')
                    .last()
                    .after(data);
            }
        );
    }
    function sitemap_remove(e) {
        if($('.field-group').length > 1) {
            $(e)
                .parents('.field-group')
                .remove();
        }
    }
JS;
    $this->registerJs($js, $this::POS_END);