<?php
    namespace backend\controllers;

    use artbox\core\models\LoginForm;
    use common\models\Settings;
    use Yii;
    use yii\web\Controller;
    use yii\filters\VerbFilter;
    use yii\filters\AccessControl;

    /**
     * Site controller
     */
    class SiteController extends Controller
    {
        /**
         * @inheritdoc
         */
        public function behaviors()
        {
            return [
                'access' => [
                    'class' => AccessControl::className(),
                    'rules' => [
                        [
                            'actions' => [
                                'login',
                                'error',
                            ],
                            'allow'   => true,
                        ],
                        [
                            'actions' => [
                                'logout',
                                'index',
                                'analytics',
                            ],
                            'allow'   => true,
                            'roles'   => [ '@' ],
                        ],
                    ],
                ],
                'verbs'  => [
                    'class'   => VerbFilter::className(),
                    'actions' => [
                        'logout'    => [ 'post' ],
                        'analytics' => [ 'post' ],
                    ],
                ],
            ];
        }
    
        /**
         * @inheritdoc
         */
        public function actions()
        {
            return [
                'error' => [
                    'class' => 'yii\web\ErrorAction',
                ],
            ];
        }
    
        /**
         * Displays homepage.
         *
         * @return string
         */
        public function actionIndex()
        {
            $settings = Settings::getInstance();
        
            if (empty( $settings->analytics_key )) {
                return $this->render('instruction');
            } else {
                return $this->render('index');
            }
        }
    
        /**
         * Login action.
         *
         * @return string
         */
        public function actionLogin()
        {
            if (!Yii::$app->user->isGuest) {
                return $this->goHome();
            }
        
            $model = new LoginForm();
            if ($model->load(Yii::$app->request->post()) && $model->login()) {
                return $this->goBack();
            } else {
                return $this->renderPartial(
                    'login',
                    [
                        'model' => $model,
                    ]
                );
            }
        }
    
        /**
         * Logout action.
         *
         * @return string
         */
        public function actionLogout()
        {
            Yii::$app->user->logout();
        
            return $this->goHome();
        }
    }
