<?php
    use artbox\core\components\SeoUrlManager;
    use artbox\core\components\Sitemap;
    use artbox\core\models\Page;
    
    $params = array_merge(
        require( __DIR__ . '/../../common/config/params.php' ),
        require( __DIR__ . '/../../common/config/params-local.php' ),
        require( __DIR__ . '/params.php' ),
        require( __DIR__ . '/params-local.php' )
    );
    
    return [
        'language'            => 'ru-RU',
        'id'                  => 'app-backend',
        'homeUrl'             => '/admin',
        'basePath'            => dirname(__DIR__),
        'controllerNamespace' => 'backend\controllers',
        'bootstrap'           => [ 'log' ],
        'controllerMap'       => [
            'profile'                            => 'artbox\core\controllers\ProfileController',
            'page'                               => 'artbox\core\controllers\PageController',
            'alias'                              => 'artbox\core\controllers\AliasController',
            'seo'                                => 'artbox\core\controllers\SeoController',
            'feedback'                           => 'artbox\core\controllers\FeedbackController',
            'weblog-article'                     => 'artbox\weblog\controllers\ArticleController',
            'category'                           => 'artbox\catalog\controllers\CategoryController',
            'brand'                              => 'artbox\catalog\controllers\BrandController',
            'product'                            => 'artbox\catalog\controllers\ProductController',
            'variant'                            => 'artbox\catalog\controllers\VariantController',
            'variant-option-group-complementary' => 'artbox\catalog\controllers\VariantOptionGroupComplController',
            'variant-option-group-exclusion'     => 'artbox\catalog\controllers\VariantOptionGroupExclController',
            'product-option-group-complementary' => 'artbox\catalog\controllers\ProductOptionGroupComplController',
            'product-option-group-exclusion'     => 'artbox\catalog\controllers\ProductOptionGroupExclController',
            'variant-option-complementary'       => 'artbox\catalog\controllers\VariantOptionComplController',
            'variant-option-exclusion'           => 'artbox\catalog\controllers\VariantOptionExclController',
            'product-option-complementary'       => 'artbox\catalog\controllers\ProductOptionComplController',
            'product-option-exclusion'           => 'artbox\catalog\controllers\ProductOptionExclController',
            'import'                             => 'artbox\catalog\controllers\ImportController',
            'blog-article'                       => 'artbox\weblog\controllers\ArticleController',
            'blog-category'                      => 'artbox\weblog\controllers\CategoryController',
            'blog-tag'                           => 'artbox\weblog\controllers\TagController',
            'order'                              => 'artbox\order\controllers\OrderController',
            'order-product'                      => 'artbox\order\controllers\OrderProductController',
            'label'                              => 'artbox\order\controllers\LabelController',
            'delivery'                           => 'artbox\order\controllers\DeliveryController',
            'payment'                            => 'artbox\order\controllers\PaymentController',
            'sitemap'                            => 'artbox\core\controllers\SitemapController',
            'comment'                            => [
                'class'    => 'artbox\webcomment\controllers\ManageController',
                'viewPath' => '@artbox/webcomment/views/manage',
            ],
            'export'                             => 'artbox\catalog\controllers\ExportController',
        ],
        'components'          => [
            'assetManager'       => [
                'bundles'         => [
                    'yiister\gentelella\assets\ThemeAsset' => [
                        'basePath' => '@webroot',
                        'baseUrl'  => '@web',
                        'js'       => [
                            'js/custom.js',
                        ],
                        'css'      => [
                            'css/custom.css',
                        ],
                    ],
                ],
                'appendTimestamp' => true,
            ],
            'request'            => [
                'csrfParam' => '_csrf-backend',
                'baseUrl'   => '/admin',
            ],
            'user'               => [
                'identityClass'   => 'artbox\core\models\User',
                'enableAutoLogin' => true,
                'identityCookie'  => [
                    'name'     => '_identity-backend',
                    'httpOnly' => true,
                ],
            ],
            'session'            => [
                // this is the name of the session cookie used for login on the backend
                'name' => 'advanced-backend',
            ],
            'log'                => [
                'traceLevel' => YII_DEBUG ? 3 : 0,
                'targets'    => [
                    [
                        'class'  => 'yii\log\FileTarget',
                        'levels' => [
                            'error',
                            'warning',
                        ],
                    ],
                ],
            ],
            'errorHandler'       => [
                'errorAction' => 'site/error',
            ],
            'urlManager'         => [
                'enablePrettyUrl' => true,
                'showScriptName'  => false,
                'rules'           => [],
            ],
            'urlManagerFrontend' => [
                'class'           => SeoUrlManager::className(),
                'baseUrl'         => '/',
                'enablePrettyUrl' => true,
                'showScriptName'  => false,
                'rules'           => [],
            ],
            'sitemap'            => [
                'class'    => Sitemap::className(),
                'entities' => [
                    [
                        'class'      => Page::className(),
                        'conditions' => [
                            [ 'in_menu' => 1 ],
                        ],
                        'url'        => 'page/view',
                    ],
                ],
            ],
        ],
        'params'              => $params,
    ];
