<?php
    
    namespace artweb\artbox\ecommerce\models;
    
    use artweb\artbox\comment\models\interfaces\RatingCacheInterface;
    use Yii;
    use yii\db\ActiveRecord;

    /**
     * This is the model class for table "product_to_rating".
     *
     * @property integer $id
     * @property integer $product_id
     * @property double  $value
     * @property Product $product
     */
    class ProductToRating extends ActiveRecord implements RatingCacheInterface
    {
        /**
         * @inheritdoc
         */
        public static function tableName()
        {
            return 'product_to_rating';
        }
        
        /**
         * @inheritdoc
         */
        public function rules()
        {
            return [
                [
                    [ 'product_id' ],
                    'required',
                ],
                [
                    [ 'product_id' ],
                    'integer',
                ],
                [
                    [ 'value' ],
                    'number',
                ],
                [
                    [ 'product_id' ],
                    'unique',
                ],
                [
                    [ 'product_id' ],
                    'exist',
                    'skipOnError'     => true,
                    'targetClass'     => Product::className(),
                    'targetAttribute' => [ 'product_id' => 'id' ],
                ],
            ];
        }
        
        /**
         * @inheritdoc
         */
        public function attributeLabels()
        {
            return [
                'id'         => Yii::t('app', 'ID'),
                'product_id' => Yii::t('app', 'Product ID'),
                'value'      => Yii::t('app', 'Value'),
            ];
        }
        
        /**
         * @return \yii\db\ActiveQuery
         */
        public function getProduct()
        {
            return $this->hasOne(Product::className(), [ 'id' => 'product_id' ]);
        }
    
        /**
         * @inheritdoc
         */
        public function getLinkAttribute(): string
        {
            return 'product_id';
        }
    
        /**
         * @inheritdoc
         */
        public function getValue(): float
        {
            return $this->value;
        }
    
        /**
         * @inheritdoc
         */
        public function setValue(float $value)
        {
            $this->value = $value;
        }
    }
