<?php
    
    namespace artweb\artbox\design\models;
    
    use yii\base\Model;
    use yii\data\ActiveDataProvider;
    
    /**
     * SliderSearch represents the model behind the search form about `artweb\artbox\design\models\Slider`.
     */
    class SliderSearch extends Slider
    {
        
        public $location;
        
        /**
         * @inheritdoc
         */
        public function rules()
        {
            return [
                [
                    [
                        'id',
                        'status',
                    ],
                    'integer',
                ],
                [
                    [ 'title' ],
                    'safe',
                ],
            ];
        }
        
        /**
         * @inheritdoc
         */
        public function scenarios()
        {
            // bypass scenarios() implementation in the parent class
            return Model::scenarios();
        }
        
        /**
         * Creates data provider instance with search query applied
         *
         * @param array $params
         *
         * @return ActiveDataProvider
         */
        public function search($params)
        {
            $query = Slider::find();
            
            // add conditions that should always apply here
            
            $dataProvider = new ActiveDataProvider(
                [
                    'query' => $query,
                ]
            );
            
            $this->load($params);
            
            if (!$this->validate()) {
                // uncomment the following line if you do not want to return any records when validation fails
                // $query->where('0=1');
                return $dataProvider;
            }
            
            // grid filtering conditions
            $query->andFilterWhere(
                [
                    'id'     => $this->id,
                    'status' => $this->status,
                ]
            );
            
            $query->andFilterWhere(
                [
                    'like',
                    'title',
                    $this->title,
                ]
            );
            
            return $dataProvider;
        }
    }
