<?php
    
    use yii\helpers\Html;
    use yii\grid\GridView;
    use yiister\gentelella\widgets\Panel;
    use yii\helpers\Url;
    
    /* @var $this yii\web\View */
    /* @var $dataProvider yii\data\ActiveDataProvider */
    /* @var $shop_id integer */
    
    $this->title = \Yii::t('stock', 'Variant Count');
    $this->params[ 'breadcrumbs' ][] = $this->title;
?>
<div class="variant-to-shop-index">
    <?php
        $xPanel = Panel::begin(
            [
                'header' => \Yii::t('stock', Html::encode($this->title)),
            ]
        );
    ?>
  <h1><?= Html::encode($this->title) ?></h1>
  
  <p>
      <?= Html::a(\Yii::t('stock', 'Create'),
                  [
                      'create',
                      'shop_id' => $shop_id,
                  ],
                  [ 'class' => 'btn btn-success' ]
      ) ?>

      <?= Html::a(\Yii::t('stock', 'Import'),
                  [
                      'import',
                      'shop_id' => $shop_id,
                  ],
                  [ 'class' => 'btn btn-success' ]
      ) ?>
  </p>
    <?= GridView::widget(
        [
            'dataProvider' => $dataProvider,
            'columns'      => [
                [ 'class' => 'yii\grid\SerialColumn' ],
                [
                    'attribute' => \Yii::t('stock', 'Address'),
                    'value'     => 'shop.lang.address',
                ],
                [
                    'attribute' => \Yii::t('stock', 'Sku'),
                    'value'     => 'variant.sku',
                ],
                'count',
                
                [ 'class' => 'yii\grid\ActionColumn',
                  'template' => '{view} {update} {delete}{link}',
                'buttons' => [
                 'link' => function ($url,$model,$key) {
                      return Html::a('<span class="fa fa-download transfer" title="Перенести на другой склад">&nbsp; </span>');
        },
        'icon'  => 'gift',
    ],
                
                ],
            ],
        ]
    ); ?>
    <?php
        $xPanel::end();
    ?>
</div>
