<?php
    
    /**
     * @var $sheet PHPExcel_Worksheet
     * @var $this  View
     * @var $shop_id integer
     */
    
    
    use kartik\file\FileInput;
    use yii\helpers\Html;
    use yii\web\View;
    use yii\widgets\ActiveForm;
    use yiister\gentelella\widgets\Panel;
    
    $js = <<< JS
$(document).on('submit', '#my-form', function(e) {
  var formData = new FormData(this);
  var form = $(this);
  
  $(document.body).append('<div class="animated yt-loader"></div>');
  
  $.ajax({
      url: "/admin/variant-count/upload?shop_id="+$(".shop").val(),
      data: formData,
      type: "POST",
      success: function(data) {
        console.log(data);
        $('.yt-loader').remove();
        new PNotify({
                        title: "Success",
                        text: "File updated",
                        type: "success",
                        styling: "bootstrap3",
                        icon: "glyphicon glyphicon-exclamation-sign"
                      });
      },
      cache: false,
      contentType: false,
      processData: false
  });
  
  e.preventDefault();
});
JS;
    
    $this->registerJs($js, View::POS_READY);
    
    $this->params[ 'breadcrumbs' ][] = \Yii::t('stock', 'Import');
?>

<?php $panel = Panel::begin() ?>

<?php $form = ActiveForm::begin(
    [
        'options' => [
            'enctype' => 'multipart/form-data',
        ],
        'id'      => 'my-form',
        'action'  => 'import/upload',
    ]
) ?>

<?php
    echo '<label class="control-label">' . \Yii::t('catalog', 'Upload Document') . '</label>';
    echo FileInput::widget(
        [
            'name' => 'attachment_3',
        ]
    );
?>

<?php echo Html::hiddenInput('shop_id', $shop_id, [
      "class" => "shop"
    ])
?>

<?= Html::submitButton(
    \Yii::t('catalog', 'Send'),
    [
        'class' => 'btn btn-success',
    ]
) ?>



<div id="progress-container">

</div>

<?php $form::end() ?>

<?php $panel::end() ?>

