<?php
    
    use yii\helpers\Html;
    use yiister\gentelella\widgets\Panel;
    
    /* @var $this yii\web\View */
    /* @var $model artbox\stock\models\VariantToShop */
    
    /* @var $shop \artbox\stock\models\Shop */
    $this->title = \Yii::t('stock', 'Add Product') . ': ' . $shop->lang->address;
    $this->params[ 'breadcrumbs' ][] = [ 'label' => \Yii::t('stock', 'Variant Count'),
                                         'url'   => [
                                             'index',
                                             'shop_id' => $shop->id,
                                         ],
    ];
    $this->params[ 'breadcrumbs' ][] = $this->title;
?>
<div class="variant-to-shop-create">
    <?php
        $xPanel = Panel::begin(
            [
                'header' => \Yii::t('stock', Html::encode($this->title)),
            ]
        );
    ?>
  <h1><?= Html::encode($this->title) ?></h1>
    
    <?= $this->render(
        '_form',
        [
            'model' => $model,
            'shop'  => $shop,
        ]
    ) ?>
    <?php
        $xPanel::end();
    ?>
</div>
