<?php
    
    use yii\helpers\Html;
    use yii\widgets\DetailView;
    use yiister\gentelella\widgets\Panel;
    
    /* @var $this yii\web\View */
    /* @var $model artbox\stock\models\Shop */
    
    $this->title = $model->lang->title;
    $this->params[ 'breadcrumbs' ][] = [
        'label' => Yii::t('stock', 'Shops'),
        'url'   => [ 'index' ],
    ];
    $this->params[ 'breadcrumbs' ][] = $this->title;
?>
<div class="shop-view">
    <?php
        $xPanel = Panel::begin(
            [
                'header' => \Yii::t('stock', Html::encode($this->title)),
            ]
        );
    ?>
  <h1><?= Html::encode($this->title) ?></h1>
  
  <p>
      <?= Html::a(
          \Yii::t('stock', 'Update'),
          [
              'update',
              'id' => $model->id,
          ],
          [ 'class' => 'btn btn-primary' ]
      ) ?>
      <?= Html::a(
          \Yii::t('stock', 'Delete'),
          [
              'delete',
              'id' => $model->id,
          ],
          [
              'class' => 'btn btn-danger',
              'data'  => [
                  'confirm' => 'Are you sure you want to delete this item?',
                  'method'  => 'post',
              ],
          ]
      ) ?>
  </p>
    
    <?= DetailView::widget(
        [
            'model' => $model,
            'attributes' => [
                'id',
                'lang.title',
                [
                    'attribute' => 'lang.alias.value',
                    'label'     => \Yii::t('catalog', 'Alias'),
                ],
                'lang.description:html',
                'lang.address',
                'sort',
                'status:boolean',
            ],
        ]
    ) ?>
    <?php
        $xPanel::end();
    ?>
</div>
