<?php
    
    use yii\helpers\Html;
    use yii\widgets\ActiveForm;
    use artbox\core\widgets\LanguageForm;
    use kartik\select2\Select2;
    use artbox\core\components\imagemanager\components\ImageManagerInputWidget;
    
    /* @var $this yii\web\View */
    /* @var $model artbox\stock\models\Shop */
    /* @var $form yii\widgets\ActiveForm */
    /* @var $modelLangs artbox\stock\models\ShopLang */
    $days = [
        \Yii::t('stock', 'Mon'),
        \Yii::t('stock', 'Tue'),
        \Yii::t('stock', 'Wed'),
        \Yii::t('stock', 'Thu'),
        \Yii::t('stock', 'Fri'),
        \Yii::t('stock', 'Sat'),
        \Yii::t('stock', 'Sun'),
    ];
    
    \artbox\stock\assets\StockAsset::register($this);
    \artbox\stock\assets\MapAsset::register($this);

?>
<div class="shop-form">
    <?php $form = ActiveForm::begin(); ?>
    <?= LanguageForm::widget(
        [
            'modelLangs' => $modelLangs,
            'formView'   => '@artbox/stock/views/shop/_form_language',
            'form'       => $form,
        ]
    ) ?>
    
    <?= $form->field($model, 'mode')
             ->textarea() ?>
    
    
    <?= Select2::widget(
        [
            'model'   => $model,
            'attribute'    => 'city_id',
            'value'   => array_keys($model->cities),
            'data'    => $model->cities,
            'options' => [ 'placeholder' => 'Выберите город ...' ],
        ]
    ); ?>
    <?= $form->field($model, 'image_id')
             ->widget(
                 ImageManagerInputWidget::className(),
                 [
                     'aspectRatio'                  => ( 16 / 9 ),
                     //set the aspect ratio
                     'showPreview'                  => true,
                     //false to hide the preview
                     'showDeletePickedImageConfirm' => false,
                     //on true show warning before detach image
                 ]
             ); ?>
    <?= $form->field($model, 'sort')
             ->textInput() ?>
    
    <?= $form->field($model, 'status')
             ->checkbox() ?>
    <?= $form->field($model, 'shop')
             ->checkbox() ?>
  
  <div class="form-group">
      <?= Html::submitButton(
          $model->isNewRecord ? \Yii::t('stock', 'Create') : \Yii::t('stock', 'Update'),
          [ 'class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary' ]
      ) ?>
  </div>
    
    <?php ActiveForm::end(); ?>
</div>

