<?php
    
    use yii\data\ActiveDataProvider;
    use yii\helpers\Html;
    use yii\grid\GridView;
    use yii\web\View;
    use yiister\gentelella\widgets\Panel;
    
    /**
     * @var View               $this
     * @var ActiveDataProvider $dataProvider
     */
    
    $this->title = 'Cities';
    $this->params[ 'breadcrumbs' ][] = \Yii::t('stock', $this->title);
?>
<div class="city-index">
    <?php
        $xPanel = Panel::begin(
            [
                'header' => \Yii::t('stock', Html::encode($this->title)),
            ]
        );
    ?>
  <h1><?= \Yii::t('stock', Html::encode($this->title)) ?></h1>
  
  <p>
      <?= Html::a(\Yii::t('stock', 'Create City'), [ 'create' ], [ 'class' => 'btn btn-success' ]) ?>
  </p>
    <?= GridView::widget(
        [
            'dataProvider' => $dataProvider,
            'columns'      => [
                [ 'class' => 'yii\grid\SerialColumn' ],
                
                'id',
                [
                    'attribute' => \Yii::t('stock', 'Title'),
                    'value'     => 'lang.title',
                ],
                'sort',
                'status:boolean',
                
                [ 'class' => 'yii\grid\ActionColumn' ],
            ],
        ]
    ); ?>
    <?php
        $xPanel::end();
    ?>
</div>
