<?php
    
    use yii\helpers\Html;
    use yii\widgets\ActiveForm;
    use artbox\core\widgets\LanguageForm;
    
    /* @var $this yii\web\View */
    /* @var $model artbox\stock\models\City */
    /* @var $form yii\widgets\ActiveForm */
    /* @var $modelLangs artbox\stock\models\CityLang */
    
    \artbox\stock\assets\StockAsset::register($this);
    \artbox\stock\assets\MapAsset::register($this);
?>

<div class="city-form">
    
    <?php $form = ActiveForm::begin(); ?>
    <?= LanguageForm::widget(
        [
            'modelLangs' => $modelLangs,
            'formView'   => '@artbox/stock/views/city/_form_language',
            'form'       => $form,
        ]
    ) ?>
    <?= $form->field($model, 'coordsArr[lat]')
             ->textInput(
                 [
                     'value' => ( isset($model->coordsArr[ 'lat' ]) ) ? $model->coordsArr[ 'lat' ] : '',
                     'id'    => 'lat',
                     'size'  => 10,
                 ]
             )
             ->label(false); ?>
    <?= $form->field($model, 'coordsArr[lng]')
             ->textInput(
                 [
                     'value' => ( isset($model->coordsArr[ 'lng' ]) ) ? $model->coordsArr[ 'lng' ] : '',
                     'id'    => 'lng',
                     'size'  => 10,
                 ]
             )
             ->label(false); ?>
    <?= $form->field($model, 'sort')
             ->textInput() ?>
    
    <?= $form->field($model, 'status')
             ->checkbox() ?>
  
  <div class="form-group">
      <?= Html::submitButton(
          $model->isNewRecord ? \Yii::t('stock', 'Create') : \Yii::t('stock', 'Update'),
          [ 'class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary' ]
      ) ?>
  </div>
    
    <?php ActiveForm::end(); ?>

</div>
<script>
    window.onload = function() {
        $(document)
            .on('blur', '#city_title', function() {
                var address = $("#city_title")
                    .val();
                console.log(address);
                var geocoder = new google.maps.Geocoder();
                geocoder.geocode({'address': address}, function(results, status) {
                    console.log(status);
                    if (status == google.maps.GeocoderStatus.OK) {

                        $("#lat")
                            .val(results[ 0 ].geometry.location.lat());
                        $("#lng")
                            .val(results[ 0 ].geometry.location.lng());
                    } else {
                        alert("Geocode was not successful for the following reason: " + status);
                    }
                });
            });
    }

</script>
