<?php
    
    namespace artbox\stock\models;
    
    use artbox\core\components\imagemanager\models\ImageManager;
    use artbox\core\models\Language;
    use artbox\core\behaviors\LanguageBehavior;
    use yii\helpers\Json;
    use yii\web\Request;
    use yii\db\ActiveRecord;
    /**
     * This is the model class for table "shop".
     *
     * @property integer    $id
     * @property string     $mode
     * @property integer    $city_id
     * @property integer    $sort
     * @property boolean    $status
     * @property City       $city
     * @property ShopLang[] $shopLangs
     * @property Language[] $languages
     * @property ShopLang[] $modelLangs
     *
     * @method bool saveWithLangs()
     * @method bool loadWithLangs( Request $request)
     * @method void generateLangs()
     */
    class Shop extends ActiveRecord
    {
        /**
         * @inheritdoc
         */
        public $cities = [];
        
        public function events(){
        
        }
        
        public static function tableName()
        {
            return 'shop';
        }
        public function behaviors()
        {
            return [
                'language' => [
                    'class' => LanguageBehavior::className(),
                ],
            ];
        }
        /**
         * @inheritdoc
         */
        public function rules()
        {
            return [
                [
                    [
                        'city_id',
                        'sort',
                        'image_id'
                    ],
                    'integer',
                ],
                [
                    [ 'status' ],
                    'boolean',
                ],
                [
                    [ 'shop' ],
                    'boolean',
                ],
                [
                    [
                        'mode',
                        'modeStr',
                    ],
                    'safe',
                ],
                [
                    [
                        'coords',
                        'coordsArr',
                    ],
                    'safe',
                ],
                [
                    [ 'city_id' ],
                    'exist',
                    'skipOnError'     => true,
                    'targetClass'     => City::className(),
                    'targetAttribute' => [ 'city_id' => 'id' ],
                ],
                [
                    [ 'image_id' ],
                    'exist',
                    'skipOnError'     => true,
                    'targetClass'     => ImageManager::className(),
                    'targetAttribute' => [ 'image_id' => 'id' ],
                ],
            ];
        }
        
        /**
         * @inheritdoc
         */
        public function attributeLabels()
        {
            return [
                'id'      => 'ID',
                'mode'    => \Yii::t('stock', 'Mode'),
                'city_id' => 'City ID',
                'sort'    => \Yii::t('stock', 'Sort'),
                'status'  => \Yii::t('stock', 'Status'),
                'shop'  => \Yii::t('stock', 'Shop'),

            ];
        }
        
        /**
         * @return \yii\db\ActiveQuery
         */
        public function getCity()
        {
            return $this->hasOne(City::className(), [ 'id' => 'city_id' ]);
        }
        public function getImage()
        {
            return $this->hasOne(ImageManager::className(), [ 'id' => 'image_id' ]);
        }
        
        public function getCities()
        {
            $cities = City::find()
                          ->with([ 'lang' ])
                          ->all();
            foreach ($cities as $city) {
                $this->cities[ $city->id ] = $city->lang->title;
            }
            
        }
        
        /**
         * @return \yii\db\ActiveQuery
         */
        public function getShopLangs()
        {
            return $this->hasMany(ShopLang::className(), [ 'shop_id' => 'id' ]);
        }
        
        /**
         * @return \yii\db\ActiveQuery
         */
        public function getLanguages()
        {
            return $this->hasMany(Language::className(), [ 'id' => 'language_id' ])
                        ->viaTable('shop_lang', [ 'shop_id' => 'id' ]);
        }
        
        public function setModeStr($value)
        {
            $this->mode = Json::encode($value);
        }
        
        public function getModeStr()
        {
            return Json::decode($this->mode);
        }
        
        public function setCoordsArr($value)
        {
            $this->coords = Json::encode($value);
        }
        
        public function getCoordsArr()
        {
            return Json::decode($this->coords);
        }
        
    }
