<?php

namespace artbox\stock\models;

use Yii;
use artbox\core\behaviors\SlugBehavior;
use artbox\core\models\Alias;
use artbox\core\models\Language;

/**
 * This is the model class for table "city_lang".
 *
 * @property integer $city_id
 * @property integer $language_id
 * @property string $title
 * @property integer $alias_id
 * @property string $description
 *
 * @property Alias $alias
 * @property City $city
 * @property Language $language
 */
class CityLang extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'city_lang';
    }

    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            'slug' => [
                'class'  => SlugBehavior::className(),
                'action' => 'city/view',
                'params' => [
                    'id' => 'city_id',
                ],
                'fields' => [
                    'title'       => \Yii::t('stock', 'Title'),
                    'description' => \Yii::t('stock', 'Description'),
                ],
            ],
        ];
    }
    public function rules()
    {
        return [
            [
                [
                    'title',
                ],
                'required',
            ],
            [
                [ 'description' ],
                'string',
            ],
            [
                [
                    'title',
                    'aliasValue',
                ],
                'string',
                'max' => 255,
            ],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'city_id' => 'City ID',
            'language_id' => 'Language ID',
            'title' => \Yii::t('stock', 'Title'),
            'alias_id' => 'Alias ID',
            'description' => \Yii::t('stock', 'Description'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getAlias()
    {
        return $this->hasOne(Alias::className(), ['id' => 'alias_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getCity()
    {
        return $this->hasOne(City::className(), ['id' => 'city_id'])->inverseOf('cityLangs');
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getLanguage()
    {
        return $this->hasOne(Language::className(), ['id' => 'language_id']);
    }
}
