<?php
    
    namespace artbox\stock\models;
    
    use Yii;
    use artbox\core\models\Language;
    use artbox\core\behaviors\LanguageBehavior;
    use yii\db\ActiveRecord;
    use yii\web\Request;
    use yii\helpers\Json;
    
    /**
     * This is the model class for table "city".
     *
     * @property integer    $id
     * @property integer    $sort
     * @property boolean    $status
     * @property CityLang[] $cityLangs
     * @property Language[] $languages
     * @property CityLang[] $modelLangs
     * @property Shop[]     $shops
     * @method bool saveWithLangs()
     * @method bool loadWithLangs( Request $request )
     * @method void generateLangs()
     */
    class City extends ActiveRecord
    {
        /**
         * @inheritdoc
         */
        public static function tableName()
        {
            return 'city';
        }
        
        public function behaviors()
        {
            return [
                'language' => [
                    'class' => LanguageBehavior::className(),
                ],
            ];
        }
        
        /**
         * @inheritdoc
         */
        public function rules()
        {
            return [
                [
                    [ 'sort' ],
                    'integer',
                ],
                [
                    [ 'status' ],
                    'boolean',
                ],
                [
                    [
                        'coords',
                        'coordsArr',
                    ],
                    'safe',
                ],
            ];
        }
        
        /**
         * @inheritdoc
         */
        public function attributeLabels()
        {
            return [
                'id'     => 'ID',
                'sort'   => Yii::t('stock', 'Sort'),
                'status' => Yii::t('stock', 'Status'),
            ];
        }
        
        /**
         * @return \yii\db\ActiveQuery
         */
        public function getCityLangs()
        {
            return $this->hasMany(CityLang::className(), [ 'city_id' => 'id' ])
                        ->inverseOf('city');
        }
        
        /**
         * @return \yii\db\ActiveQuery
         */
        public function getLanguages()
        {
            return $this->hasMany(Language::className(), [ 'id' => 'language_id' ])
                        ->viaTable('city_lang', [ 'city_id' => 'id' ]);
        }
        
        /**
         * @return \yii\db\ActiveQuery
         */
        public function getShops()
        {
            return $this->hasMany(Shop::className(), [ 'city_id' => 'id' ]);
        }
        
        public function setCoordsArr($value)
        {
            $this->coords = Json::encode($value);
        }
        
        public function getCoordsArr()
        {
            return Json::decode($this->coords);
        }
    }
