<?php

use yii\db\Migration;

/**
 * Handles the creation of table `variant_to_shop`.
 */
class m170727_081025_create_variant_to_shop_table extends Migration
{
    /**
     * @inheritdoc
     */
    public function up()
    {
        $this->createTable('variant_to_shop', [
            'variant_id'  => $this->integer()
                                  ->notNull(),
            'shop_id' => $this->integer()
                                  ->notNull(),
            'count'   => $this->integer()->defaultValue(0),
        ]);
    
    
        $this->addPrimaryKey(
            'variant_to_shop_pk',
            'variant_to_shop',
            [
                'variant_id',
                'shop_id',
            ]
        );
    
        $this->addForeignKey(
            'variant_to_shop_variant_id_to_variant_fk',
            'variant_to_shop',
            'variant_id',
            'variant',
            'id',
            'CASCADE',
            'CASCADE'
        );
    
        $this->addForeignKey(
            'variant_to_shop_shop_id_to_shop_fk',
            'variant_to_shop',
            'shop_id',
            'shop',
            'id',
            'CASCADE',
            'CASCADE'
        );
    }

    /**
     * @inheritdoc
     */
    public function down()
    {
        $this->dropForeignKey(
            'variant_to_shop_variant_id_to_variant_fk',
            'variant_to_shop'
        );
        $this->dropForeignKey(
            'variant_to_shop_shop_id_to_shop_fk',
            'variant_to_shop'
        );
        $this->dropTable('variant_to_shop');
        
    }
}
