<?php

use yii\db\Migration;

class m170724_124809_shop_lang extends Migration
{
    public function safeUp()
    {
        $this->createTable(
            'shop_lang',
            [
                'shop_id'    => $this->integer(32)
                    ->notNull(),
                'language_id' => $this->integer(32)
                    ->notNull(),
                'title'       => $this->string(255)
                    ->notNull(),
                'alias_id'    => $this->integer(),
                'description' => $this->text(),
            ]
        );

        $this->createIndex('shop_lang_alias_id', 'shop_lang', 'alias_id', true);
        $this->addPrimaryKey(
            'shop_lang_pk',
            'shop_lang',
            [
                'shop_id',
                'language_id',
            ]
        );

        $this->addForeignKey(
            'shop_lang_shop_id_to_shop_fk',
            'shop_lang',
            'shop_id',
            'shop',
            'id',
            'CASCADE',
            'CASCADE'
        );

        $this->addForeignKey(
            'shop_lang_language_id_to_language_fk',
            'shop_lang',
            'language_id',
            'language',
            'id',
            'RESTRICT',
            'CASCADE'
        );

        $this->addForeignKey(
            'shop_lang_alias_id_to_alias_fk',
            'shop_lang',
            'alias_id',
            'alias',
            'id',
            'SET NULL',
            'CASCADE'
        );
    }

    public function safeDown()
    {
        $this->dropForeignKey(
            'shop_lang_alias_id_to_alias_fk',
            'shop_lang'
        );
        $this->dropForeignKey(
            'shop_lang_language_id_to_language_fk',
            'shop_lang'
        );
        $this->dropForeignKey(
            'shop_lang_city_id_to_shop_fk',
            'shop_lang'
        );
        $this->dropIndex('shop_lang_alias_id', 'shop_lang');
        $this->dropTable('shop_lang');
    }

    /*
    // Use up()/down() to run migration code without a transaction.
    public function up()
    {

    }

    public function down()
    {
        echo "m170724_124809_shop_lang cannot be reverted.\n";

        return false;
    }
    */
}
