<?php

use yii\db\Migration;

class m170724_123453_city_lang extends Migration
{
    public function safeUp()
    {
        $this->createTable(
            'city_lang',
            [
                'city_id'    => $this->integer(32)
                    ->notNull(),
                'language_id' => $this->integer(32)
                    ->notNull(),
                'title'       => $this->string(255)
                    ->notNull(),
                'alias_id'    => $this->integer(),
                'description' => $this->text(),
            ]
        );


        $this->createIndex('city_lang_alias_id', 'city_lang', 'alias_id', true);
        $this->addPrimaryKey(
            'city_lang_pk',
            'city_lang',
            [
                'city_id',
                'language_id',
            ]
        );


        $this->addForeignKey(
            'city_lang_city_id_to_city_fk',
            'city_lang',
            'city_id',
            'city',
            'id',
            'CASCADE',
            'CASCADE'
        );

        $this->addForeignKey(
            'city_lang_language_id_to_language_fk',
            'city_lang',
            'language_id',
            'language',
            'id',
            'RESTRICT',
            'CASCADE'
        );

        $this->addForeignKey(
            'city_lang_alias_id_to_alias_fk',
            'city_lang',
            'alias_id',
            'alias',
            'id',
            'SET NULL',
            'CASCADE'
        );
    }

    public function safeDown()
    {
        $this->dropForeignKey(
            'city_lang_alias_id_to_alias_fk',
            'city_lang'
        );
        $this->dropForeignKey(
            'city_lang_language_id_to_language_fk',
            'city_lang'
        );
        $this->dropForeignKey(
            'city_lang_city_id_to_city_fk',
            'city_lang'
        );
        $this->dropIndex('city_lang_alias_id', 'city_lang');
        $this->dropTable('city_lang');
    }


}
