<?php

use yii\db\Migration;

class m170721_135629_create_table_shops extends Migration
{
    public function safeUp()
    {
        $this->createTable('shop', [
            'id'            => $this->primaryKey(),
            'mode'          => $this->text(),
            'city_id'       => $this->integer(),
            'sort'      => $this->integer(),
            'status'     => $this->boolean()
                ->defaultValue(true),
            'shop'     => $this->boolean()
                                 ->defaultValue(true),
            'coords'    => $this->string(),
        ]);

        $this->addForeignKey(
            'city_city_id_fkey',
            'shop',
            'city_id',
            'city',
            'id',
            'CASCADE',
            'CASCADE'
        );
    }

    public function safeDown()
    {
        $this->dropForeignKey('city_city_id_fkey', 'shop');
        $this->dropTable('shop');
    }


    /*
    // Use up()/down() to run migration code without a transaction.
    public function up()
    {

    }
    */


}
