<?php
    
    namespace artbox\stock\controllers;
    
    use artbox\stock\models\Shop;
    use yii\data\ActiveDataProvider;
    use yii\web\Controller;
    use yii\web\NotFoundHttpException;
    use yii\filters\VerbFilter;
    use yii\filters\AccessControl;
    
    /**
     * ShopController implements the CRUD actions for Shop model.
     */
    class ShopController extends Controller
    {
        /**
         * @inheritdoc
         */
        public function getViewPath()
        {
            return '@artbox/stock/views/shop';
        }
        public function behaviors()
        {
            return [
                'access' => [
                    'class' => AccessControl::className(),
                    'rules' => [
                        [
                            'actions' => [
                                'login',
                                'error',
                            ],
                            'allow'   => true,
                        ],
                        [
                            'allow' => true,
                            'roles' => [ '@' ],
                        ],
                    ],
                ],
                'verbs'  => [
                    'class'   => VerbFilter::className(),
                    'actions' => [
                        'delete' => [ 'POST' ],
                    ],
                ],
            ];
        }
        
        /**
         * Lists all Shop models.
         *
         * @return mixed
         */
        public function actionIndex()
        {
            $dataProvider = new ActiveDataProvider(
                [
                    'query' => Shop::find(),
                ]
            );
            
            return $this->render(
                'index',
                [
                    'dataProvider' => $dataProvider,
                ]
            );
        }
        
        /**
         * Displays a single Shop model.
         *
         * @param integer $id
         *
         * @return mixed
         */
        public function actionView($id)
        {
            return $this->render(
                'view',
                [
                    'model' => $this->findModel($id),
                ]
            );
        }
        
        /**
         * Creates a new Shop model.
         * If creation is successful, the browser will be redirected to the 'view' page.
         *
         * @return mixed
         */
        public function actionCreate()
        {
            $model = new Shop();
            $model->generateLangs();
            $model->getCities();
            if ($model->loadWithLangs(\Yii::$app->request) && $model->saveWithLangs()) {
                return $this->redirect(
                    [
                        'view',
                        'id' => $model->id,
                    ]
                );
            }
            return $this->render(
                'create',
                [
                    'model'      => $model,
                    'modelLangs' => $model->modelLangs,
                ]
            );
            
        }
        
        /**
         * Updates an existing Shop model.
         * If update is successful, the browser will be redirected to the 'view' page.
         *
         * @param integer $id
         *
         * @return mixed
         */
        public function actionUpdate($id)
        {
            $model = $this->findModel($id);
            $model->generateLangs();
            $model->getCities();
            if ($model->loadWithLangs(\Yii::$app->request) && $model->saveWithLangs()) {
                return $this->redirect(
                    [
                        'view',
                        'id' => $model->id,
                    ]
                );
            }
            return $this->render(
                'update',
                [
                    'model'      => $model,
                    'modelLangs' => $model->modelLangs,
                ]
            );
        }
        
        /**
         * Deletes an existing Shop model.
         * If deletion is successful, the browser will be redirected to the 'index' page.
         *
         * @param integer $id
         *
         * @return mixed
         */
        public function actionDelete($id)
        {
            $this->findModel($id)
                 ->delete();
            
            return $this->redirect([ 'index' ]);
        }
        
        /**
         * Finds the Shop model based on its primary key value.
         * If the model is not found, a 404 HTTP exception will be thrown.
         *
         * @param integer $id
         *
         * @return Shop the loaded model
         * @throws NotFoundHttpException if the model cannot be found
         */
        protected function findModel($id)
        {
            if (( $model = Shop::findOne($id) ) !== null) {
                return $model;
            } else {
                throw new NotFoundHttpException('The requested page does not exist.');
            }
        }
    }
