﻿using System;
using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.Metadata;

namespace Maps.Entities
{
    public partial class PostgresDbContext : DbContext
    {
        protected override void OnConfiguring(DbContextOptionsBuilder optionsBuilder)
        {
            #warning To protect potentially sensitive information in your connection string, you should move it out of source code. See http://go.microsoft.com/fwlink/?LinkId=723263 for guidance on storing connection strings.
            optionsBuilder.UseNpgsql(@"User ID=coremap;Password=5F9g4V9m;Host=195.248.225.149;Port=5432;Database=coremap;Pooling=true;");
        }

        protected override void OnModelCreating(ModelBuilder modelBuilder)
        {
            modelBuilder.Entity<BusStop>(entity =>
            {
                entity.ToTable("bus_stop");

                entity.Property(e => e.BusStopId).HasColumnName("bus_stop_id");

                entity.Property(e => e.AreaLandAvailability).HasColumnName("area_land_availability");

                entity.Property(e => e.AreaStopAvailability).HasColumnName("area_stop_availability");

                entity.Property(e => e.BalanceCost).HasColumnName("balance_cost");

                entity.Property(e => e.BusStationCardId).HasColumnName("bus_station_card_id");

                entity.Property(e => e.CrossSectionNumber).HasColumnName("cross_section_number");

                entity.Property(e => e.DateActual).HasColumnName("date_actual");

                entity.Property(e => e.LocationLeft).HasColumnName("location_left");

                entity.Property(e => e.LocationRight).HasColumnName("location_right");

                entity.Property(e => e.PocketAvailability).HasColumnName("pocket_availability");

                entity.Property(e => e.Position)
                    .HasColumnName("position")
                    .HasColumnType("varchar")
                    .HasMaxLength(255);

                entity.Property(e => e.RegionId).HasColumnName("region_id");

                entity.Property(e => e.RepairCertificate)
                    .HasColumnName("repair_certificate")
                    .HasColumnType("varchar")
                    .HasMaxLength(255);

                entity.Property(e => e.RoadId).HasColumnName("road_id");

                entity.Property(e => e.SettlementId).HasColumnName("settlement_id");

                entity.Property(e => e.StateCommonId).HasColumnName("state_common_id");

                entity.Property(e => e.SurfaceTypeId).HasColumnName("surface_type_id");

                entity.Property(e => e.ToiletAvailability).HasColumnName("toilet_availability");

                entity.Property(e => e.YearBuild).HasColumnName("year_build");

                entity.Property(e => e.YearRepair).HasColumnName("year_repair");

                entity.HasOne(d => d.Region)
                    .WithMany(p => p.BusStop)
                    .HasForeignKey(d => d.RegionId)
                    .OnDelete(DeleteBehavior.Cascade)
                    .HasConstraintName("bus_stop_region_id_fkey");

                entity.HasOne(d => d.Road)
                    .WithMany(p => p.BusStop)
                    .HasForeignKey(d => d.RoadId)
                    .OnDelete(DeleteBehavior.Cascade)
                    .HasConstraintName("bus_stop_road_id_fkey");

                entity.HasOne(d => d.Settlement)
                    .WithMany(p => p.BusStop)
                    .HasForeignKey(d => d.SettlementId)
                    .OnDelete(DeleteBehavior.Cascade)
                    .HasConstraintName("bus_stop_settlement_id_fkey");

                entity.HasOne(d => d.StateCommon)
                    .WithMany(p => p.BusStop)
                    .HasForeignKey(d => d.StateCommonId)
                    .OnDelete(DeleteBehavior.Cascade)
                    .HasConstraintName("bus_stop_state_common_id_fkey");

                entity.HasOne(d => d.SurfaceType)
                    .WithMany(p => p.BusStop)
                    .HasForeignKey(d => d.SurfaceTypeId)
                    .OnDelete(DeleteBehavior.Cascade)
                    .HasConstraintName("bus_stop_surface_type_id_fkey");
            });

            modelBuilder.Entity<CrossSection>(entity =>
            {
                entity.ToTable("cross_section");

                entity.Property(e => e.CrossSectionId).HasColumnName("cross_section_id");

                entity.Property(e => e.Angle).HasColumnName("angle");

                entity.Property(e => e.Direction)
                    .HasColumnName("direction")
                    .HasColumnType("varchar")
                    .HasMaxLength(255);

                entity.Property(e => e.DistanceEdge).HasColumnName("distance_edge");

                entity.Property(e => e.LengthSection).HasColumnName("length_section");

                entity.Property(e => e.LengthSurface).HasColumnName("length_surface");

                entity.Property(e => e.LocationLeft).HasColumnName("location_left");

                entity.Property(e => e.LocationRight).HasColumnName("location_right");

                entity.Property(e => e.RegionId).HasColumnName("region_id");

                entity.Property(e => e.RoadId).HasColumnName("road_id");

                entity.Property(e => e.SafetyAvailability).HasColumnName("safety_availability");

                entity.Property(e => e.StateCommonId).HasColumnName("state_common_id");

                entity.Property(e => e.SurfaceTypeId).HasColumnName("surface_type_id");

                entity.Property(e => e.TubeAvailability).HasColumnName("tube_availability");

                entity.Property(e => e.Width).HasColumnName("width");

                entity.Property(e => e.YearBuild).HasColumnName("year_build");

                entity.Property(e => e.YearRepair).HasColumnName("year_repair");

                entity.HasOne(d => d.Region)
                    .WithMany(p => p.CrossSection)
                    .HasForeignKey(d => d.RegionId)
                    .OnDelete(DeleteBehavior.Cascade)
                    .HasConstraintName("cross_section_region_id_fkey");

                entity.HasOne(d => d.Road)
                    .WithMany(p => p.CrossSection)
                    .HasForeignKey(d => d.RoadId)
                    .OnDelete(DeleteBehavior.Cascade)
                    .HasConstraintName("cross_section_road_id_fkey");

                entity.HasOne(d => d.StateCommon)
                    .WithMany(p => p.CrossSection)
                    .HasForeignKey(d => d.StateCommonId)
                    .OnDelete(DeleteBehavior.Cascade)
                    .HasConstraintName("cross_section_state_common_id_fkey");

                entity.HasOne(d => d.SurfaceType)
                    .WithMany(p => p.CrossSection)
                    .HasForeignKey(d => d.SurfaceTypeId)
                    .OnDelete(DeleteBehavior.Cascade)
                    .HasConstraintName("cross_section_surface_type_id_fkey");
            });

            modelBuilder.Entity<DepartmentAffiliation>(entity =>
            {
                entity.ToTable("department_affiliation");

                entity.Property(e => e.DepartmentAffiliationId).HasColumnName("department_affiliation_id");

                entity.Property(e => e.Name)
                    .HasColumnName("name")
                    .HasColumnType("varchar")
                    .HasMaxLength(255);
            });

            modelBuilder.Entity<FlowIntensity>(entity =>
            {
                entity.ToTable("flow_intensity");

                entity.Property(e => e.FlowIntensityId).HasColumnName("flow_intensity_id");

                entity.Property(e => e.Begin).HasColumnName("begin");

                entity.Property(e => e.DateAdd).HasColumnName("date_add");

                entity.Property(e => e.End).HasColumnName("end");

                entity.Property(e => e.IntensityBus).HasColumnName("intensity_bus");

                entity.Property(e => e.IntensityBusCoupled).HasColumnName("intensity_bus_coupled");

                entity.Property(e => e.IntensityCar).HasColumnName("intensity_car");

                entity.Property(e => e.IntensityIncrease).HasColumnName("intensity_increase");

                entity.Property(e => e.IntensityLorryThirty).HasColumnName("intensity_lorry_thirty");

                entity.Property(e => e.IntensityLorryTwelve).HasColumnName("intensity_lorry_twelve");

                entity.Property(e => e.IntensityLorryTwelveTwenty).HasColumnName("intensity_lorry_twelve_twenty");

                entity.Property(e => e.IntensityLorryTwentyThirty).HasColumnName("intensity_lorry_twenty_thirty");

                entity.Property(e => e.IntensityMoto).HasColumnName("intensity_moto");

                entity.Property(e => e.IntensityMotoSidecar).HasColumnName("intensity_moto_sidecar");

                entity.Property(e => e.IntensityTotal).HasColumnName("intensity_total");

                entity.Property(e => e.IntensityTractorOverTen).HasColumnName("intensity_tractor_over_ten");

                entity.Property(e => e.IntensityTractorUnderTen).HasColumnName("intensity_tractor_under_ten");

                entity.Property(e => e.IntensityTruckEightFourteen).HasColumnName("intensity_truck_eight_fourteen");

                entity.Property(e => e.IntensityTruckFourteen).HasColumnName("intensity_truck_fourteen");

                entity.Property(e => e.IntensityTruckSixEight).HasColumnName("intensity_truck_six_eight");

                entity.Property(e => e.IntensityTruckTwo).HasColumnName("intensity_truck_two");

                entity.Property(e => e.IntensityTruckTwoSix).HasColumnName("intensity_truck_two_six");

                entity.Property(e => e.Location).HasColumnName("location");

                entity.Property(e => e.RegionId).HasColumnName("region_id");

                entity.Property(e => e.RoadDirectionId).HasColumnName("road_direction_id");

                entity.Property(e => e.RoadId).HasColumnName("road_id");

                entity.Property(e => e.SettlementId).HasColumnName("settlement_id");

                entity.HasOne(d => d.Region)
                    .WithMany(p => p.FlowIntensity)
                    .HasForeignKey(d => d.RegionId)
                    .OnDelete(DeleteBehavior.Cascade)
                    .HasConstraintName("flow_intensity_region_id_fkey");

                entity.HasOne(d => d.RoadDirection)
                    .WithMany(p => p.FlowIntensity)
                    .HasForeignKey(d => d.RoadDirectionId)
                    .OnDelete(DeleteBehavior.Cascade)
                    .HasConstraintName("flow_intensity_road_direction_id_fkey");

                entity.HasOne(d => d.Road)
                    .WithMany(p => p.FlowIntensity)
                    .HasForeignKey(d => d.RoadId)
                    .OnDelete(DeleteBehavior.Cascade)
                    .HasConstraintName("flow_intensity_road_id_fkey");

                entity.HasOne(d => d.Settlement)
                    .WithMany(p => p.FlowIntensity)
                    .HasForeignKey(d => d.SettlementId)
                    .OnDelete(DeleteBehavior.Cascade)
                    .HasConstraintName("flow_intensity_settlement_id_fkey");
            });

            modelBuilder.Entity<Organization>(entity =>
            {
                entity.ToTable("organization");

                entity.Property(e => e.OrganizationId).HasColumnName("organization_id");

                entity.Property(e => e.DateAdd).HasColumnName("date_add");

                entity.Property(e => e.Name)
                    .IsRequired()
                    .HasColumnName("name")
                    .HasColumnType("varchar")
                    .HasMaxLength(255);
            });

            modelBuilder.Entity<Region>(entity =>
            {
                entity.ToTable("region");

                entity.Property(e => e.RegionId).HasColumnName("region_id");

                entity.Property(e => e.Index).HasColumnName("index");

                entity.Property(e => e.Name)
                    .HasColumnName("name")
                    .HasColumnType("varchar")
                    .HasMaxLength(255);
            });

            modelBuilder.Entity<Road>(entity =>
            {
                entity.ToTable("road");

                entity.Property(e => e.RoadId).HasColumnName("road_id");

                entity.Property(e => e.AcceptTransferDoc)
                    .HasColumnName("accept_transfer_doc")
                    .HasColumnType("varchar")
                    .HasMaxLength(255);

                entity.Property(e => e.AcceptanceDoc)
                    .HasColumnName("acceptance_doc")
                    .HasColumnType("varchar")
                    .HasMaxLength(255);

                entity.Property(e => e.AuthorityAct)
                    .HasColumnName("authority_act")
                    .HasColumnType("varchar")
                    .HasMaxLength(255);

                entity.Property(e => e.EconomicValue).HasColumnName("economic_value");

                entity.Property(e => e.HistoricalBackground).HasColumnName("historical_background");

                entity.Property(e => e.Index).HasColumnName("index");

                entity.Property(e => e.LawDoc)
                    .HasColumnName("law_doc")
                    .HasColumnType("varchar")
                    .HasMaxLength(255);

                entity.Property(e => e.Length).HasColumnName("length");

                entity.Property(e => e.Name)
                    .HasColumnName("name")
                    .HasColumnType("varchar")
                    .HasMaxLength(255);

                entity.Property(e => e.RoadTypeId).HasColumnName("road_type_id");

                entity.Property(e => e.Value).HasColumnName("value");

                entity.HasOne(d => d.RoadType)
                    .WithMany(p => p.Road)
                    .HasForeignKey(d => d.RoadTypeId)
                    .OnDelete(DeleteBehavior.Cascade)
                    .HasConstraintName("road_road_type_id_fkey");
            });

            modelBuilder.Entity<RoadCategory>(entity =>
            {
                entity.ToTable("road_category");

                entity.Property(e => e.RoadCategoryId).HasColumnName("road_category_id");

                entity.Property(e => e.Value)
                    .HasColumnName("value")
                    .HasColumnType("varchar")
                    .HasMaxLength(255);
            });

            modelBuilder.Entity<RoadDirection>(entity =>
            {
                entity.ToTable("road_direction");

                entity.Property(e => e.RoadDirectionId).HasColumnName("road_direction_id");

                entity.Property(e => e.DirectionName)
                    .IsRequired()
                    .HasColumnName("direction_name")
                    .HasColumnType("varchar")
                    .HasMaxLength(255);
            });

            modelBuilder.Entity<RoadPassport>(entity =>
            {
                entity.ToTable("road_passport");

                entity.Property(e => e.RoadPassportId).HasColumnName("road_passport_id");

                entity.Property(e => e.Begin).HasColumnName("begin");

                entity.Property(e => e.End).HasColumnName("end");

                entity.Property(e => e.RegionId).HasColumnName("region_id");

                entity.Property(e => e.RoadId).HasColumnName("road_id");

                entity.HasOne(d => d.Region)
                    .WithMany(p => p.RoadPassport)
                    .HasForeignKey(d => d.RegionId)
                    .OnDelete(DeleteBehavior.Cascade)
                    .HasConstraintName("road_passport_region_id_fkey");

                entity.HasOne(d => d.Road)
                    .WithMany(p => p.RoadPassport)
                    .HasForeignKey(d => d.RoadId)
                    .OnDelete(DeleteBehavior.Cascade)
                    .HasConstraintName("road_passport_road_id_fkey");
            });

            modelBuilder.Entity<RoadService>(entity =>
            {
                entity.ToTable("road_service");

                entity.Property(e => e.RoadServiceId).HasColumnName("road_service_id");

                entity.Property(e => e.Begin).HasColumnName("begin");

                entity.Property(e => e.End).HasColumnName("end");

                entity.Property(e => e.OrganizationId).HasColumnName("organization_id");

                entity.Property(e => e.RegionId).HasColumnName("region_id");

                entity.Property(e => e.RoadDirectionId).HasColumnName("road_direction_id");

                entity.Property(e => e.RoadId).HasColumnName("road_id");

                entity.Property(e => e.YearBegin).HasColumnName("year_begin");

                entity.HasOne(d => d.Organization)
                    .WithMany(p => p.RoadService)
                    .HasForeignKey(d => d.OrganizationId)
                    .OnDelete(DeleteBehavior.Cascade)
                    .HasConstraintName("road_service_organization_id_fkey");

                entity.HasOne(d => d.Region)
                    .WithMany(p => p.RoadService)
                    .HasForeignKey(d => d.RegionId)
                    .OnDelete(DeleteBehavior.Cascade)
                    .HasConstraintName("road_service_region_id_fkey");

                entity.HasOne(d => d.RoadDirection)
                    .WithMany(p => p.RoadService)
                    .HasForeignKey(d => d.RoadDirectionId)
                    .OnDelete(DeleteBehavior.Cascade)
                    .HasConstraintName("road_service_road_direction_id_fkey");

                entity.HasOne(d => d.Road)
                    .WithMany(p => p.RoadService)
                    .HasForeignKey(d => d.RoadId)
                    .OnDelete(DeleteBehavior.Cascade)
                    .HasConstraintName("road_service_road_id_fkey");
            });

            modelBuilder.Entity<RoadSurface>(entity =>
            {
                entity.ToTable("road_surface");

                entity.Property(e => e.RoadSurfaceId).HasColumnName("road_surface_id");

                entity.Property(e => e.Begin).HasColumnName("begin");

                entity.Property(e => e.CrossSectionNumber).HasColumnName("cross_section_number");

                entity.Property(e => e.ElastisityModule).HasColumnName("elastisity_module");

                entity.Property(e => e.End).HasColumnName("end");

                entity.Property(e => e.LaneCountLeft).HasColumnName("lane_count_left");

                entity.Property(e => e.LaneCountRight).HasColumnName("lane_count_right");

                entity.Property(e => e.RegionId).HasColumnName("region_id");

                entity.Property(e => e.RoadDirectionId).HasColumnName("road_direction_id");

                entity.Property(e => e.RoadId).HasColumnName("road_id");

                entity.Property(e => e.RoadSurfaceConstructionId)
                    .HasColumnName("road_surface_construction_id")
                    .HasColumnType("varchar")
                    .HasMaxLength(255);

                entity.Property(e => e.StateCommonId).HasColumnName("state_common_id");

                entity.Property(e => e.SurfaceTreatmentId).HasColumnName("surface_treatment_id");

                entity.Property(e => e.SurfaceTypeId).HasColumnName("surface_type_id");

                entity.HasOne(d => d.Region)
                    .WithMany(p => p.RoadSurface)
                    .HasForeignKey(d => d.RegionId)
                    .OnDelete(DeleteBehavior.Cascade)
                    .HasConstraintName("road_surface_region_id_fkey");

                entity.HasOne(d => d.RoadDirection)
                    .WithMany(p => p.RoadSurface)
                    .HasForeignKey(d => d.RoadDirectionId)
                    .OnDelete(DeleteBehavior.Cascade)
                    .HasConstraintName("road_surface_road_direction_id_fkey");

                entity.HasOne(d => d.Road)
                    .WithMany(p => p.RoadSurface)
                    .HasForeignKey(d => d.RoadId)
                    .OnDelete(DeleteBehavior.Cascade)
                    .HasConstraintName("road_surface_road_id_fkey");

                entity.HasOne(d => d.StateCommon)
                    .WithMany(p => p.RoadSurface)
                    .HasForeignKey(d => d.StateCommonId)
                    .OnDelete(DeleteBehavior.Cascade)
                    .HasConstraintName("road_surface_state_common_id_fkey");

                entity.HasOne(d => d.SurfaceTreatment)
                    .WithMany(p => p.RoadSurface)
                    .HasForeignKey(d => d.SurfaceTreatmentId)
                    .OnDelete(DeleteBehavior.Cascade)
                    .HasConstraintName("road_surface_surface_treatment_id_fkey");

                entity.HasOne(d => d.SurfaceType)
                    .WithMany(p => p.RoadSurface)
                    .HasForeignKey(d => d.SurfaceTypeId)
                    .OnDelete(DeleteBehavior.Cascade)
                    .HasConstraintName("road_surface_surface_type_id_fkey");
            });

            modelBuilder.Entity<RoadType>(entity =>
            {
                entity.ToTable("road_type");

                entity.Property(e => e.RoadTypeId).HasColumnName("road_type_id");

                entity.Property(e => e.Definition)
                    .HasColumnName("definition")
                    .HasColumnType("varchar")
                    .HasMaxLength(255);

                entity.Property(e => e.Value)
                    .HasColumnName("value")
                    .HasColumnType("varchar")
                    .HasMaxLength(255);
            });

            modelBuilder.Entity<RoadWidth>(entity =>
            {
                entity.ToTable("road_width");

                entity.Property(e => e.RoadWidthId).HasColumnName("road_width_id");

                entity.Property(e => e.Begin).HasColumnName("begin");

                entity.Property(e => e.CountLaneLeft).HasColumnName("count_lane_left");

                entity.Property(e => e.CountLaneRight).HasColumnName("count_lane_right");

                entity.Property(e => e.End).HasColumnName("end");

                entity.Property(e => e.RegionId).HasColumnName("region_id");

                entity.Property(e => e.RoadId).HasColumnName("road_id");

                entity.Property(e => e.WidthReverseRoad).HasColumnName("width_reverse_road");

                entity.Property(e => e.WidthRoadsideLeft).HasColumnName("width_roadside_left");

                entity.Property(e => e.WidthRoadsideRight).HasColumnName("width_roadside_right");

                entity.Property(e => e.WidthRoadwayForward).HasColumnName("width_roadway_forward");

                entity.Property(e => e.WidthStrip).HasColumnName("width_strip");

                entity.HasOne(d => d.Region)
                    .WithMany(p => p.RoadWidth)
                    .HasForeignKey(d => d.RegionId)
                    .OnDelete(DeleteBehavior.Cascade)
                    .HasConstraintName("road_width_region_id_fkey");

                entity.HasOne(d => d.Road)
                    .WithMany(p => p.RoadWidth)
                    .HasForeignKey(d => d.RoadId)
                    .OnDelete(DeleteBehavior.Cascade)
                    .HasConstraintName("road_width_road_id_fkey");
            });

            modelBuilder.Entity<ServiceObject>(entity =>
            {
                entity.ToTable("service_object");

                entity.Property(e => e.ServiceObjectId).HasColumnName("service_object_id");

                entity.Property(e => e.ArrangementElements).HasColumnName("arrangement_elements");

                entity.Property(e => e.Capacity).HasColumnName("capacity");

                entity.Property(e => e.DepartmentAffiliationId).HasColumnName("department_affiliation_id");

                entity.Property(e => e.Distance).HasColumnName("distance");

                entity.Property(e => e.LocationAxis).HasColumnName("location_axis");

                entity.Property(e => e.LocationLeft).HasColumnName("location_left");

                entity.Property(e => e.LocationRight).HasColumnName("location_right");

                entity.Property(e => e.RegionId).HasColumnName("region_id");

                entity.Property(e => e.RoadId).HasColumnName("road_id");

                entity.Property(e => e.ServiceObjectTypeId).HasColumnName("service_object_type_id");

                entity.Property(e => e.SettlementId).HasColumnName("settlement_id");

                entity.HasOne(d => d.DepartmentAffiliation)
                    .WithMany(p => p.ServiceObject)
                    .HasForeignKey(d => d.DepartmentAffiliationId)
                    .OnDelete(DeleteBehavior.Cascade)
                    .HasConstraintName("service_object_department_affiliation_id_fkey");

                entity.HasOne(d => d.Region)
                    .WithMany(p => p.ServiceObject)
                    .HasForeignKey(d => d.RegionId)
                    .OnDelete(DeleteBehavior.Cascade)
                    .HasConstraintName("service_object_region_id_fkey");

                entity.HasOne(d => d.Road)
                    .WithMany(p => p.ServiceObject)
                    .HasForeignKey(d => d.RoadId)
                    .OnDelete(DeleteBehavior.Cascade)
                    .HasConstraintName("service_object_road_id_fkey");

                entity.HasOne(d => d.ServiceObjectType)
                    .WithMany(p => p.ServiceObject)
                    .HasForeignKey(d => d.ServiceObjectTypeId)
                    .OnDelete(DeleteBehavior.Cascade)
                    .HasConstraintName("service_object_service_object_type_id_fkey");

                entity.HasOne(d => d.Settlement)
                    .WithMany(p => p.ServiceObject)
                    .HasForeignKey(d => d.SettlementId)
                    .OnDelete(DeleteBehavior.Cascade)
                    .HasConstraintName("service_object_settlement_id_fkey");
            });

            modelBuilder.Entity<ServiceObjectType>(entity =>
            {
                entity.ToTable("service_object_type");

                entity.Property(e => e.ServiceObjectTypeId).HasColumnName("service_object_type_id");

                entity.Property(e => e.Name)
                    .HasColumnName("name")
                    .HasColumnType("varchar")
                    .HasMaxLength(255);
            });

            modelBuilder.Entity<Settlement>(entity =>
            {
                entity.ToTable("settlement");

                entity.Property(e => e.SettlementId).HasColumnName("settlement_id");

                entity.Property(e => e.Name)
                    .IsRequired()
                    .HasColumnName("name")
                    .HasColumnType("varchar")
                    .HasMaxLength(255);

                entity.Property(e => e.Sign)
                    .HasColumnName("sign")
                    .HasColumnType("varchar")
                    .HasMaxLength(255);
            });

            modelBuilder.Entity<SettlementAddressLink>(entity =>
            {
                entity.ToTable("settlement_address_link");

                entity.Property(e => e.SettlementAddressLinkId).HasColumnName("settlement_address_link_id");

                entity.Property(e => e.Begin).HasColumnName("begin");

                entity.Property(e => e.Distance).HasColumnName("distance");

                entity.Property(e => e.End).HasColumnName("end");

                entity.Property(e => e.RegionId).HasColumnName("region_id");

                entity.Property(e => e.RoadId).HasColumnName("road_id");

                entity.Property(e => e.SettlementId).HasColumnName("settlement_id");

                entity.Property(e => e.SettlementLocationId).HasColumnName("settlement_location_id");

                entity.HasOne(d => d.Region)
                    .WithMany(p => p.SettlementAddressLink)
                    .HasForeignKey(d => d.RegionId)
                    .OnDelete(DeleteBehavior.Cascade)
                    .HasConstraintName("settlement_address_link_region_id_fkey");

                entity.HasOne(d => d.Road)
                    .WithMany(p => p.SettlementAddressLink)
                    .HasForeignKey(d => d.RoadId)
                    .OnDelete(DeleteBehavior.Cascade)
                    .HasConstraintName("settlement_address_link_road_id_fkey");

                entity.HasOne(d => d.Settlement)
                    .WithMany(p => p.SettlementAddressLink)
                    .HasForeignKey(d => d.SettlementId)
                    .OnDelete(DeleteBehavior.Cascade)
                    .HasConstraintName("settlement_address_link_settlement_id_fkey");

                entity.HasOne(d => d.SettlementLocation)
                    .WithMany(p => p.SettlementAddressLink)
                    .HasForeignKey(d => d.SettlementLocationId)
                    .OnDelete(DeleteBehavior.Cascade)
                    .HasConstraintName("settlement_address_link_settlement_location_id_fkey");
            });

            modelBuilder.Entity<SettlementLocation>(entity =>
            {
                entity.ToTable("settlement_location");

                entity.Property(e => e.SettlementLocationId).HasColumnName("settlement_location_id");

                entity.Property(e => e.Value)
                    .IsRequired()
                    .HasColumnName("value")
                    .HasColumnType("varchar")
                    .HasMaxLength(255);
            });

            modelBuilder.Entity<StateCommon>(entity =>
            {
                entity.ToTable("state_common");

                entity.Property(e => e.StateCommonId).HasColumnName("state_common_id");

                entity.Property(e => e.Value)
                    .HasColumnName("value")
                    .HasColumnType("varchar")
                    .HasMaxLength(255);
            });

            modelBuilder.Entity<SurfaceTreatment>(entity =>
            {
                entity.ToTable("surface_treatment");

                entity.Property(e => e.SurfaceTreatmentId).HasColumnName("surface_treatment_id");

                entity.Property(e => e.Name)
                    .HasColumnName("name")
                    .HasColumnType("varchar")
                    .HasMaxLength(255);
            });

            modelBuilder.Entity<SurfaceType>(entity =>
            {
                entity.ToTable("surface_type");

                entity.Property(e => e.SurfaceTypeId).HasColumnName("surface_type_id");

                entity.Property(e => e.Name)
                    .HasColumnName("name")
                    .HasColumnType("varchar")
                    .HasMaxLength(255);
            });
        }

        public virtual DbSet<BusStop> BusStop { get; set; }
        public virtual DbSet<CrossSection> CrossSection { get; set; }
        public virtual DbSet<DepartmentAffiliation> DepartmentAffiliation { get; set; }
        public virtual DbSet<FlowIntensity> FlowIntensity { get; set; }
        public virtual DbSet<Organization> Organization { get; set; }
        public virtual DbSet<Region> Region { get; set; }
        public virtual DbSet<Road> Road { get; set; }
        public virtual DbSet<RoadCategory> RoadCategory { get; set; }
        public virtual DbSet<RoadDirection> RoadDirection { get; set; }
        public virtual DbSet<RoadPassport> RoadPassport { get; set; }
        public virtual DbSet<RoadService> RoadService { get; set; }
        public virtual DbSet<RoadSurface> RoadSurface { get; set; }
        public virtual DbSet<RoadType> RoadType { get; set; }
        public virtual DbSet<RoadWidth> RoadWidth { get; set; }
        public virtual DbSet<ServiceObject> ServiceObject { get; set; }
        public virtual DbSet<ServiceObjectType> ServiceObjectType { get; set; }
        public virtual DbSet<Settlement> Settlement { get; set; }
        public virtual DbSet<SettlementAddressLink> SettlementAddressLink { get; set; }
        public virtual DbSet<SettlementLocation> SettlementLocation { get; set; }
        public virtual DbSet<StateCommon> StateCommon { get; set; }
        public virtual DbSet<SurfaceTreatment> SurfaceTreatment { get; set; }
        public virtual DbSet<SurfaceType> SurfaceType { get; set; }
    }
}