using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.Rendering;
using Microsoft.EntityFrameworkCore;
using Maps.Entities;

namespace maps_core.Controllers
{
    public class SurfaceTreatmentController : Controller
    {
        private readonly PostgresDbContext _context;

        public SurfaceTreatmentController(PostgresDbContext context)
        {
            _context = context;    
        }

        // GET: SurfaceTreatment
        public async Task<IActionResult> Index()
        {
            return View(await _context.SurfaceTreatment.ToListAsync());
        }

        // GET: SurfaceTreatment/Details/5
        public async Task<IActionResult> Details(int? id)
        {
            if (id == null)
            {
                return NotFound();
            }

            var surfaceTreatment = await _context.SurfaceTreatment.SingleOrDefaultAsync(m => m.SurfaceTreatmentId == id);
            if (surfaceTreatment == null)
            {
                return NotFound();
            }

            return View(surfaceTreatment);
        }

        // GET: SurfaceTreatment/Create
        public IActionResult Create()
        {
            return View();
        }

        // POST: SurfaceTreatment/Create
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> Create([Bind("SurfaceTreatmentId,Name")] SurfaceTreatment surfaceTreatment)
        {
            if (ModelState.IsValid)
            {
                _context.Add(surfaceTreatment);
                await _context.SaveChangesAsync();
                return RedirectToAction("Index");
            }
            return View(surfaceTreatment);
        }

        // GET: SurfaceTreatment/Edit/5
        public async Task<IActionResult> Edit(int? id)
        {
            if (id == null)
            {
                return NotFound();
            }

            var surfaceTreatment = await _context.SurfaceTreatment.SingleOrDefaultAsync(m => m.SurfaceTreatmentId == id);
            if (surfaceTreatment == null)
            {
                return NotFound();
            }
            return View(surfaceTreatment);
        }

        // POST: SurfaceTreatment/Edit/5
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> Edit(int id, [Bind("SurfaceTreatmentId,Name")] SurfaceTreatment surfaceTreatment)
        {
            if (id != surfaceTreatment.SurfaceTreatmentId)
            {
                return NotFound();
            }

            if (ModelState.IsValid)
            {
                try
                {
                    _context.Update(surfaceTreatment);
                    await _context.SaveChangesAsync();
                }
                catch (DbUpdateConcurrencyException)
                {
                    if (!SurfaceTreatmentExists(surfaceTreatment.SurfaceTreatmentId))
                    {
                        return NotFound();
                    }
                    else
                    {
                        throw;
                    }
                }
                return RedirectToAction("Index");
            }
            return View(surfaceTreatment);
        }

        // GET: SurfaceTreatment/Delete/5
        public async Task<IActionResult> Delete(int? id)
        {
            if (id == null)
            {
                return NotFound();
            }

            var surfaceTreatment = await _context.SurfaceTreatment.SingleOrDefaultAsync(m => m.SurfaceTreatmentId == id);
            if (surfaceTreatment == null)
            {
                return NotFound();
            }

            return View(surfaceTreatment);
        }

        // POST: SurfaceTreatment/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> DeleteConfirmed(int id)
        {
            var surfaceTreatment = await _context.SurfaceTreatment.SingleOrDefaultAsync(m => m.SurfaceTreatmentId == id);
            _context.SurfaceTreatment.Remove(surfaceTreatment);
            await _context.SaveChangesAsync();
            return RedirectToAction("Index");
        }

        private bool SurfaceTreatmentExists(int id)
        {
            return _context.SurfaceTreatment.Any(e => e.SurfaceTreatmentId == id);
        }
    }
}
