using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.Rendering;
using Microsoft.EntityFrameworkCore;
using Maps.Entities;

namespace maps_core.Controllers
{
    public class SettlementLocationController : Controller
    {
        private readonly PostgresDbContext _context;

        public SettlementLocationController(PostgresDbContext context)
        {
            _context = context;    
        }

        // GET: SettlementLocation
        public async Task<IActionResult> Index()
        {
            return View(await _context.SettlementLocation.ToListAsync());
        }

        // GET: SettlementLocation/Details/5
        public async Task<IActionResult> Details(int? id)
        {
            if (id == null)
            {
                return NotFound();
            }

            var settlementLocation = await _context.SettlementLocation.SingleOrDefaultAsync(m => m.SettlementLocationId == id);
            if (settlementLocation == null)
            {
                return NotFound();
            }

            return View(settlementLocation);
        }

        // GET: SettlementLocation/Create
        public IActionResult Create()
        {
            return View();
        }

        // POST: SettlementLocation/Create
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> Create([Bind("SettlementLocationId,Value")] SettlementLocation settlementLocation)
        {
            if (ModelState.IsValid)
            {
                _context.Add(settlementLocation);
                await _context.SaveChangesAsync();
                return RedirectToAction("Index");
            }
            return View(settlementLocation);
        }

        // GET: SettlementLocation/Edit/5
        public async Task<IActionResult> Edit(int? id)
        {
            if (id == null)
            {
                return NotFound();
            }

            var settlementLocation = await _context.SettlementLocation.SingleOrDefaultAsync(m => m.SettlementLocationId == id);
            if (settlementLocation == null)
            {
                return NotFound();
            }
            return View(settlementLocation);
        }

        // POST: SettlementLocation/Edit/5
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> Edit(int id, [Bind("SettlementLocationId,Value")] SettlementLocation settlementLocation)
        {
            if (id != settlementLocation.SettlementLocationId)
            {
                return NotFound();
            }

            if (ModelState.IsValid)
            {
                try
                {
                    _context.Update(settlementLocation);
                    await _context.SaveChangesAsync();
                }
                catch (DbUpdateConcurrencyException)
                {
                    if (!SettlementLocationExists(settlementLocation.SettlementLocationId))
                    {
                        return NotFound();
                    }
                    else
                    {
                        throw;
                    }
                }
                return RedirectToAction("Index");
            }
            return View(settlementLocation);
        }

        // GET: SettlementLocation/Delete/5
        public async Task<IActionResult> Delete(int? id)
        {
            if (id == null)
            {
                return NotFound();
            }

            var settlementLocation = await _context.SettlementLocation.SingleOrDefaultAsync(m => m.SettlementLocationId == id);
            if (settlementLocation == null)
            {
                return NotFound();
            }

            return View(settlementLocation);
        }

        // POST: SettlementLocation/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> DeleteConfirmed(int id)
        {
            var settlementLocation = await _context.SettlementLocation.SingleOrDefaultAsync(m => m.SettlementLocationId == id);
            _context.SettlementLocation.Remove(settlementLocation);
            await _context.SaveChangesAsync();
            return RedirectToAction("Index");
        }

        private bool SettlementLocationExists(int id)
        {
            return _context.SettlementLocation.Any(e => e.SettlementLocationId == id);
        }
    }
}
