using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.Rendering;
using Microsoft.EntityFrameworkCore;
using Maps.Entities;

namespace maps_core.Controllers
{
    public class ServiceObjectTypeController : Controller
    {
        private readonly PostgresDbContext _context;

        public ServiceObjectTypeController(PostgresDbContext context)
        {
            _context = context;    
        }

        // GET: ServiceObjectType
        public async Task<IActionResult> Index()
        {
            return View(await _context.ServiceObjectType.ToListAsync());
        }

        // GET: ServiceObjectType/Details/5
        public async Task<IActionResult> Details(int? id)
        {
            if (id == null)
            {
                return NotFound();
            }

            var serviceObjectType = await _context.ServiceObjectType.SingleOrDefaultAsync(m => m.ServiceObjectTypeId == id);
            if (serviceObjectType == null)
            {
                return NotFound();
            }

            return View(serviceObjectType);
        }

        // GET: ServiceObjectType/Create
        public IActionResult Create()
        {
            return View();
        }

        // POST: ServiceObjectType/Create
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> Create([Bind("ServiceObjectTypeId,Name")] ServiceObjectType serviceObjectType)
        {
            if (ModelState.IsValid)
            {
                _context.Add(serviceObjectType);
                await _context.SaveChangesAsync();
                return RedirectToAction("Index");
            }
            return View(serviceObjectType);
        }

        // GET: ServiceObjectType/Edit/5
        public async Task<IActionResult> Edit(int? id)
        {
            if (id == null)
            {
                return NotFound();
            }

            var serviceObjectType = await _context.ServiceObjectType.SingleOrDefaultAsync(m => m.ServiceObjectTypeId == id);
            if (serviceObjectType == null)
            {
                return NotFound();
            }
            return View(serviceObjectType);
        }

        // POST: ServiceObjectType/Edit/5
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> Edit(int id, [Bind("ServiceObjectTypeId,Name")] ServiceObjectType serviceObjectType)
        {
            if (id != serviceObjectType.ServiceObjectTypeId)
            {
                return NotFound();
            }

            if (ModelState.IsValid)
            {
                try
                {
                    _context.Update(serviceObjectType);
                    await _context.SaveChangesAsync();
                }
                catch (DbUpdateConcurrencyException)
                {
                    if (!ServiceObjectTypeExists(serviceObjectType.ServiceObjectTypeId))
                    {
                        return NotFound();
                    }
                    else
                    {
                        throw;
                    }
                }
                return RedirectToAction("Index");
            }
            return View(serviceObjectType);
        }

        // GET: ServiceObjectType/Delete/5
        public async Task<IActionResult> Delete(int? id)
        {
            if (id == null)
            {
                return NotFound();
            }

            var serviceObjectType = await _context.ServiceObjectType.SingleOrDefaultAsync(m => m.ServiceObjectTypeId == id);
            if (serviceObjectType == null)
            {
                return NotFound();
            }

            return View(serviceObjectType);
        }

        // POST: ServiceObjectType/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> DeleteConfirmed(int id)
        {
            var serviceObjectType = await _context.ServiceObjectType.SingleOrDefaultAsync(m => m.ServiceObjectTypeId == id);
            _context.ServiceObjectType.Remove(serviceObjectType);
            await _context.SaveChangesAsync();
            return RedirectToAction("Index");
        }

        private bool ServiceObjectTypeExists(int id)
        {
            return _context.ServiceObjectType.Any(e => e.ServiceObjectTypeId == id);
        }
    }
}
