using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.Rendering;
using Microsoft.EntityFrameworkCore;
using Maps.Entities;

namespace maps_core.Controllers
{
    public class RoadWidthController : Controller
    {
        private readonly PostgresDbContext _context;

        public RoadWidthController(PostgresDbContext context)
        {
            _context = context;    
        }

        // GET: RoadWidth
        public async Task<IActionResult> Index()
        {
            var postgresDbContext = _context.RoadWidth.Include(r => r.Region).Include(r => r.Road);
            return View(await postgresDbContext.ToListAsync());
        }

        // GET: RoadWidth/Details/5
        public async Task<IActionResult> Details(int? id)
        {
            if (id == null)
            {
                return NotFound();
            }

            var roadWidth = await _context.RoadWidth.SingleOrDefaultAsync(m => m.RoadWidthId == id);
            if (roadWidth == null)
            {
                return NotFound();
            }

            return View(roadWidth);
        }

        // GET: RoadWidth/Create
        public IActionResult Create()
        {
            ViewData["RegionId"] = new SelectList(_context.Region, "RegionId", "RegionId");
            ViewData["RoadId"] = new SelectList(_context.Road, "RoadId", "RoadId");
            return View();
        }

        // POST: RoadWidth/Create
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> Create([Bind("RoadWidthId,Begin,CountLaneLeft,CountLaneRight,End,RegionId,RoadId,WidthReverseRoad,WidthRoadsideLeft,WidthRoadsideRight,WidthRoadwayForward,WidthStrip")] RoadWidth roadWidth)
        {
            if (ModelState.IsValid)
            {
                _context.Add(roadWidth);
                await _context.SaveChangesAsync();
                return RedirectToAction("Index");
            }
            ViewData["RegionId"] = new SelectList(_context.Region, "RegionId", "RegionId", roadWidth.RegionId);
            ViewData["RoadId"] = new SelectList(_context.Road, "RoadId", "RoadId", roadWidth.RoadId);
            return View(roadWidth);
        }

        // GET: RoadWidth/Edit/5
        public async Task<IActionResult> Edit(int? id)
        {
            if (id == null)
            {
                return NotFound();
            }

            var roadWidth = await _context.RoadWidth.SingleOrDefaultAsync(m => m.RoadWidthId == id);
            if (roadWidth == null)
            {
                return NotFound();
            }
            ViewData["RegionId"] = new SelectList(_context.Region, "RegionId", "RegionId", roadWidth.RegionId);
            ViewData["RoadId"] = new SelectList(_context.Road, "RoadId", "RoadId", roadWidth.RoadId);
            return View(roadWidth);
        }

        // POST: RoadWidth/Edit/5
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> Edit(int id, [Bind("RoadWidthId,Begin,CountLaneLeft,CountLaneRight,End,RegionId,RoadId,WidthReverseRoad,WidthRoadsideLeft,WidthRoadsideRight,WidthRoadwayForward,WidthStrip")] RoadWidth roadWidth)
        {
            if (id != roadWidth.RoadWidthId)
            {
                return NotFound();
            }

            if (ModelState.IsValid)
            {
                try
                {
                    _context.Update(roadWidth);
                    await _context.SaveChangesAsync();
                }
                catch (DbUpdateConcurrencyException)
                {
                    if (!RoadWidthExists(roadWidth.RoadWidthId))
                    {
                        return NotFound();
                    }
                    else
                    {
                        throw;
                    }
                }
                return RedirectToAction("Index");
            }
            ViewData["RegionId"] = new SelectList(_context.Region, "RegionId", "RegionId", roadWidth.RegionId);
            ViewData["RoadId"] = new SelectList(_context.Road, "RoadId", "RoadId", roadWidth.RoadId);
            return View(roadWidth);
        }

        // GET: RoadWidth/Delete/5
        public async Task<IActionResult> Delete(int? id)
        {
            if (id == null)
            {
                return NotFound();
            }

            var roadWidth = await _context.RoadWidth.SingleOrDefaultAsync(m => m.RoadWidthId == id);
            if (roadWidth == null)
            {
                return NotFound();
            }

            return View(roadWidth);
        }

        // POST: RoadWidth/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> DeleteConfirmed(int id)
        {
            var roadWidth = await _context.RoadWidth.SingleOrDefaultAsync(m => m.RoadWidthId == id);
            _context.RoadWidth.Remove(roadWidth);
            await _context.SaveChangesAsync();
            return RedirectToAction("Index");
        }

        private bool RoadWidthExists(int id)
        {
            return _context.RoadWidth.Any(e => e.RoadWidthId == id);
        }
    }
}
