using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.Rendering;
using Microsoft.EntityFrameworkCore;
using Maps.Entities;

namespace maps_core.Controllers
{
    public class RoadTypeController : Controller
    {
        private readonly PostgresDbContext _context;

        public RoadTypeController(PostgresDbContext context)
        {
            _context = context;    
        }

        // GET: RoadType
        public async Task<IActionResult> Index()
        {
            return View(await _context.RoadType.ToListAsync());
        }

        // GET: RoadType/Details/5
        public async Task<IActionResult> Details(int? id)
        {
            if (id == null)
            {
                return NotFound();
            }

            var roadType = await _context.RoadType.SingleOrDefaultAsync(m => m.RoadTypeId == id);
            if (roadType == null)
            {
                return NotFound();
            }

            return View(roadType);
        }

        // GET: RoadType/Create
        public IActionResult Create()
        {
            return View();
        }

        // POST: RoadType/Create
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> Create([Bind("RoadTypeId,Definition,Value")] RoadType roadType)
        {
            if (ModelState.IsValid)
            {
                _context.Add(roadType);
                await _context.SaveChangesAsync();
                return RedirectToAction("Index");
            }
            return View(roadType);
        }

        // GET: RoadType/Edit/5
        public async Task<IActionResult> Edit(int? id)
        {
            if (id == null)
            {
                return NotFound();
            }

            var roadType = await _context.RoadType.SingleOrDefaultAsync(m => m.RoadTypeId == id);
            if (roadType == null)
            {
                return NotFound();
            }
            return View(roadType);
        }

        // POST: RoadType/Edit/5
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> Edit(int id, [Bind("RoadTypeId,Definition,Value")] RoadType roadType)
        {
            if (id != roadType.RoadTypeId)
            {
                return NotFound();
            }

            if (ModelState.IsValid)
            {
                try
                {
                    _context.Update(roadType);
                    await _context.SaveChangesAsync();
                }
                catch (DbUpdateConcurrencyException)
                {
                    if (!RoadTypeExists(roadType.RoadTypeId))
                    {
                        return NotFound();
                    }
                    else
                    {
                        throw;
                    }
                }
                return RedirectToAction("Index");
            }
            return View(roadType);
        }

        // GET: RoadType/Delete/5
        public async Task<IActionResult> Delete(int? id)
        {
            if (id == null)
            {
                return NotFound();
            }

            var roadType = await _context.RoadType.SingleOrDefaultAsync(m => m.RoadTypeId == id);
            if (roadType == null)
            {
                return NotFound();
            }

            return View(roadType);
        }

        // POST: RoadType/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> DeleteConfirmed(int id)
        {
            var roadType = await _context.RoadType.SingleOrDefaultAsync(m => m.RoadTypeId == id);
            _context.RoadType.Remove(roadType);
            await _context.SaveChangesAsync();
            return RedirectToAction("Index");
        }

        private bool RoadTypeExists(int id)
        {
            return _context.RoadType.Any(e => e.RoadTypeId == id);
        }
    }
}
