using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.Rendering;
using Microsoft.EntityFrameworkCore;
using Maps.Entities;

namespace maps_core.Controllers
{
    public class RoadPassportController : Controller
    {
        private readonly PostgresDbContext _context;

        public RoadPassportController(PostgresDbContext context)
        {
            _context = context;    
        }

        // GET: RoadPassport
        public async Task<IActionResult> Index()
        {
            var postgresDbContext = _context.RoadPassport.Include(r => r.Region).Include(r => r.Road);
            return View(await postgresDbContext.ToListAsync());
        }

        // GET: RoadPassport/Details/5
        public async Task<IActionResult> Details(int? id)
        {
            if (id == null)
            {
                return NotFound();
            }

            var roadPassport = await _context.RoadPassport.SingleOrDefaultAsync(m => m.RoadPassportId == id);
            if (roadPassport == null)
            {
                return NotFound();
            }

            return View(roadPassport);
        }

        // GET: RoadPassport/Create
        public IActionResult Create()
        {
            ViewData["RegionId"] = new SelectList(_context.Region, "RegionId", "RegionId");
            ViewData["RoadId"] = new SelectList(_context.Road, "RoadId", "RoadId");
            return View();
        }

        // POST: RoadPassport/Create
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> Create([Bind("RoadPassportId,Begin,End,RegionId,RoadId")] RoadPassport roadPassport)
        {
            if (ModelState.IsValid)
            {
                _context.Add(roadPassport);
                await _context.SaveChangesAsync();
                return RedirectToAction("Index");
            }
            ViewData["RegionId"] = new SelectList(_context.Region, "RegionId", "RegionId", roadPassport.RegionId);
            ViewData["RoadId"] = new SelectList(_context.Road, "RoadId", "RoadId", roadPassport.RoadId);
            return View(roadPassport);
        }

        // GET: RoadPassport/Edit/5
        public async Task<IActionResult> Edit(int? id)
        {
            if (id == null)
            {
                return NotFound();
            }

            var roadPassport = await _context.RoadPassport.SingleOrDefaultAsync(m => m.RoadPassportId == id);
            if (roadPassport == null)
            {
                return NotFound();
            }
            ViewData["RegionId"] = new SelectList(_context.Region, "RegionId", "RegionId", roadPassport.RegionId);
            ViewData["RoadId"] = new SelectList(_context.Road, "RoadId", "RoadId", roadPassport.RoadId);
            return View(roadPassport);
        }

        // POST: RoadPassport/Edit/5
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> Edit(int id, [Bind("RoadPassportId,Begin,End,RegionId,RoadId")] RoadPassport roadPassport)
        {
            if (id != roadPassport.RoadPassportId)
            {
                return NotFound();
            }

            if (ModelState.IsValid)
            {
                try
                {
                    _context.Update(roadPassport);
                    await _context.SaveChangesAsync();
                }
                catch (DbUpdateConcurrencyException)
                {
                    if (!RoadPassportExists(roadPassport.RoadPassportId))
                    {
                        return NotFound();
                    }
                    else
                    {
                        throw;
                    }
                }
                return RedirectToAction("Index");
            }
            ViewData["RegionId"] = new SelectList(_context.Region, "RegionId", "RegionId", roadPassport.RegionId);
            ViewData["RoadId"] = new SelectList(_context.Road, "RoadId", "RoadId", roadPassport.RoadId);
            return View(roadPassport);
        }

        // GET: RoadPassport/Delete/5
        public async Task<IActionResult> Delete(int? id)
        {
            if (id == null)
            {
                return NotFound();
            }

            var roadPassport = await _context.RoadPassport.SingleOrDefaultAsync(m => m.RoadPassportId == id);
            if (roadPassport == null)
            {
                return NotFound();
            }

            return View(roadPassport);
        }

        // POST: RoadPassport/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> DeleteConfirmed(int id)
        {
            var roadPassport = await _context.RoadPassport.SingleOrDefaultAsync(m => m.RoadPassportId == id);
            _context.RoadPassport.Remove(roadPassport);
            await _context.SaveChangesAsync();
            return RedirectToAction("Index");
        }

        private bool RoadPassportExists(int id)
        {
            return _context.RoadPassport.Any(e => e.RoadPassportId == id);
        }
    }
}
