using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.Rendering;
using Microsoft.EntityFrameworkCore;
using Maps.Entities;

namespace maps_core.Controllers
{
    public class RoadDirectionController : Controller
    {
        private readonly PostgresDbContext _context;

        public RoadDirectionController(PostgresDbContext context)
        {
            _context = context;    
        }

        // GET: RoadDirection
        public async Task<IActionResult> Index()
        {
            return View(await _context.RoadDirection.ToListAsync());
        }

        // GET: RoadDirection/Details/5
        public async Task<IActionResult> Details(int? id)
        {
            if (id == null)
            {
                return NotFound();
            }

            var roadDirection = await _context.RoadDirection.SingleOrDefaultAsync(m => m.RoadDirectionId == id);
            if (roadDirection == null)
            {
                return NotFound();
            }

            return View(roadDirection);
        }

        // GET: RoadDirection/Create
        public IActionResult Create()
        {
            return View();
        }

        // POST: RoadDirection/Create
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> Create([Bind("RoadDirectionId,DirectionName")] RoadDirection roadDirection)
        {
            if (ModelState.IsValid)
            {
                _context.Add(roadDirection);
                await _context.SaveChangesAsync();
                return RedirectToAction("Index");
            }
            return View(roadDirection);
        }

        // GET: RoadDirection/Edit/5
        public async Task<IActionResult> Edit(int? id)
        {
            if (id == null)
            {
                return NotFound();
            }

            var roadDirection = await _context.RoadDirection.SingleOrDefaultAsync(m => m.RoadDirectionId == id);
            if (roadDirection == null)
            {
                return NotFound();
            }
            return View(roadDirection);
        }

        // POST: RoadDirection/Edit/5
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> Edit(int id, [Bind("RoadDirectionId,DirectionName")] RoadDirection roadDirection)
        {
            if (id != roadDirection.RoadDirectionId)
            {
                return NotFound();
            }

            if (ModelState.IsValid)
            {
                try
                {
                    _context.Update(roadDirection);
                    await _context.SaveChangesAsync();
                }
                catch (DbUpdateConcurrencyException)
                {
                    if (!RoadDirectionExists(roadDirection.RoadDirectionId))
                    {
                        return NotFound();
                    }
                    else
                    {
                        throw;
                    }
                }
                return RedirectToAction("Index");
            }
            return View(roadDirection);
        }

        // GET: RoadDirection/Delete/5
        public async Task<IActionResult> Delete(int? id)
        {
            if (id == null)
            {
                return NotFound();
            }

            var roadDirection = await _context.RoadDirection.SingleOrDefaultAsync(m => m.RoadDirectionId == id);
            if (roadDirection == null)
            {
                return NotFound();
            }

            return View(roadDirection);
        }

        // POST: RoadDirection/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> DeleteConfirmed(int id)
        {
            var roadDirection = await _context.RoadDirection.SingleOrDefaultAsync(m => m.RoadDirectionId == id);
            _context.RoadDirection.Remove(roadDirection);
            await _context.SaveChangesAsync();
            return RedirectToAction("Index");
        }

        private bool RoadDirectionExists(int id)
        {
            return _context.RoadDirection.Any(e => e.RoadDirectionId == id);
        }
    }
}
