using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.Rendering;
using Microsoft.EntityFrameworkCore;
using Maps.Entities;

namespace maps_core.Controllers
{
    public class DepartmentAffiliationController : Controller
    {
        private readonly PostgresDbContext _context;

        public DepartmentAffiliationController(PostgresDbContext context)
        {
            _context = context;    
        }

        // GET: DepartmentAffiliation
        public async Task<IActionResult> Index()
        {
            return View(await _context.DepartmentAffiliation.ToListAsync());
        }

        // GET: DepartmentAffiliation/Details/5
        public async Task<IActionResult> Details(int? id)
        {
            if (id == null)
            {
                return NotFound();
            }

            var departmentAffiliation = await _context.DepartmentAffiliation.SingleOrDefaultAsync(m => m.DepartmentAffiliationId == id);
            if (departmentAffiliation == null)
            {
                return NotFound();
            }

            return View(departmentAffiliation);
        }

        // GET: DepartmentAffiliation/Create
        public IActionResult Create()
        {
            return View();
        }

        // POST: DepartmentAffiliation/Create
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> Create([Bind("DepartmentAffiliationId,Name")] DepartmentAffiliation departmentAffiliation)
        {
            if (ModelState.IsValid)
            {
                _context.Add(departmentAffiliation);
                await _context.SaveChangesAsync();
                return RedirectToAction("Index");
            }
            return View(departmentAffiliation);
        }

        // GET: DepartmentAffiliation/Edit/5
        public async Task<IActionResult> Edit(int? id)
        {
            if (id == null)
            {
                return NotFound();
            }

            var departmentAffiliation = await _context.DepartmentAffiliation.SingleOrDefaultAsync(m => m.DepartmentAffiliationId == id);
            if (departmentAffiliation == null)
            {
                return NotFound();
            }
            return View(departmentAffiliation);
        }

        // POST: DepartmentAffiliation/Edit/5
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> Edit(int id, [Bind("DepartmentAffiliationId,Name")] DepartmentAffiliation departmentAffiliation)
        {
            if (id != departmentAffiliation.DepartmentAffiliationId)
            {
                return NotFound();
            }

            if (ModelState.IsValid)
            {
                try
                {
                    _context.Update(departmentAffiliation);
                    await _context.SaveChangesAsync();
                }
                catch (DbUpdateConcurrencyException)
                {
                    if (!DepartmentAffiliationExists(departmentAffiliation.DepartmentAffiliationId))
                    {
                        return NotFound();
                    }
                    else
                    {
                        throw;
                    }
                }
                return RedirectToAction("Index");
            }
            return View(departmentAffiliation);
        }

        // GET: DepartmentAffiliation/Delete/5
        public async Task<IActionResult> Delete(int? id)
        {
            if (id == null)
            {
                return NotFound();
            }

            var departmentAffiliation = await _context.DepartmentAffiliation.SingleOrDefaultAsync(m => m.DepartmentAffiliationId == id);
            if (departmentAffiliation == null)
            {
                return NotFound();
            }

            return View(departmentAffiliation);
        }

        // POST: DepartmentAffiliation/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> DeleteConfirmed(int id)
        {
            var departmentAffiliation = await _context.DepartmentAffiliation.SingleOrDefaultAsync(m => m.DepartmentAffiliationId == id);
            _context.DepartmentAffiliation.Remove(departmentAffiliation);
            await _context.SaveChangesAsync();
            return RedirectToAction("Index");
        }

        private bool DepartmentAffiliationExists(int id)
        {
            return _context.DepartmentAffiliation.Any(e => e.DepartmentAffiliationId == id);
        }
    }
}
