﻿using System;
using System.Collections.Generic;

namespace Maps.Entities
{
    public partial class Road
    {
        public Road()
        {
            BusStop = new HashSet<BusStop>();
            CrossSection = new HashSet<CrossSection>();
            FlowIntensity = new HashSet<FlowIntensity>();
            RoadPassport = new HashSet<RoadPassport>();
            RoadService = new HashSet<RoadService>();
            RoadSurface = new HashSet<RoadSurface>();
            RoadWidth = new HashSet<RoadWidth>();
            ServiceObject = new HashSet<ServiceObject>();
            SettlementAddressLink = new HashSet<SettlementAddressLink>();
        }

        public int RoadId { get; set; }
        public string Name { get; set; }
        public string Value { get; set; }
        public double? Length { get; set; }
        public string HistoricalBackground { get; set; }
        public string EconomicValue { get; set; }
        public string LawDoc { get; set; }
        public string AcceptTransferDoc { get; set; }
        public string AcceptanceDoc { get; set; }
        public string AuthorityAct { get; set; }
        public int? RoadTypeId { get; set; }
        public int Index { get; set; }

        public virtual ICollection<BusStop> BusStop { get; set; }
        public virtual ICollection<CrossSection> CrossSection { get; set; }
        public virtual ICollection<FlowIntensity> FlowIntensity { get; set; }
        public virtual ICollection<RoadPassport> RoadPassport { get; set; }
        public virtual ICollection<RoadService> RoadService { get; set; }
        public virtual ICollection<RoadSurface> RoadSurface { get; set; }
        public virtual ICollection<RoadWidth> RoadWidth { get; set; }
        public virtual ICollection<ServiceObject> ServiceObject { get; set; }
        public virtual ICollection<SettlementAddressLink> SettlementAddressLink { get; set; }
        public virtual RoadType RoadType { get; set; }
    }
}
