using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.Rendering;
using Microsoft.EntityFrameworkCore;
using Maps.Entities;

namespace maps_core.Controllers
{
    public class SurfaceTypeController : Controller
    {
        private readonly PostgresDbContext _context;

        public SurfaceTypeController(PostgresDbContext context)
        {
            _context = context;    
        }

        // GET: SurfaceType
        public async Task<IActionResult> Index()
        {
            return View(await _context.SurfaceType.ToListAsync());
        }

        // GET: SurfaceType/Details/5
        public async Task<IActionResult> Details(int? id)
        {
            if (id == null)
            {
                return NotFound();
            }

            var surfaceType = await _context.SurfaceType.SingleOrDefaultAsync(m => m.SurfaceTypeId == id);
            if (surfaceType == null)
            {
                return NotFound();
            }

            return View(surfaceType);
        }

        // GET: SurfaceType/Create
        public IActionResult Create()
        {
            return View();
        }

        // POST: SurfaceType/Create
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> Create([Bind("SurfaceTypeId,Name")] SurfaceType surfaceType)
        {
            if (ModelState.IsValid)
            {
                _context.Add(surfaceType);
                await _context.SaveChangesAsync();
                return RedirectToAction("Index");
            }
            return View(surfaceType);
        }

        // GET: SurfaceType/Edit/5
        public async Task<IActionResult> Edit(int? id)
        {
            if (id == null)
            {
                return NotFound();
            }

            var surfaceType = await _context.SurfaceType.SingleOrDefaultAsync(m => m.SurfaceTypeId == id);
            if (surfaceType == null)
            {
                return NotFound();
            }
            return View(surfaceType);
        }

        // POST: SurfaceType/Edit/5
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> Edit(int id, [Bind("SurfaceTypeId,Name")] SurfaceType surfaceType)
        {
            if (id != surfaceType.SurfaceTypeId)
            {
                return NotFound();
            }

            if (ModelState.IsValid)
            {
                try
                {
                    _context.Update(surfaceType);
                    await _context.SaveChangesAsync();
                }
                catch (DbUpdateConcurrencyException)
                {
                    if (!SurfaceTypeExists(surfaceType.SurfaceTypeId))
                    {
                        return NotFound();
                    }
                    else
                    {
                        throw;
                    }
                }
                return RedirectToAction("Index");
            }
            return View(surfaceType);
        }

        // GET: SurfaceType/Delete/5
        public async Task<IActionResult> Delete(int? id)
        {
            if (id == null)
            {
                return NotFound();
            }

            var surfaceType = await _context.SurfaceType.SingleOrDefaultAsync(m => m.SurfaceTypeId == id);
            if (surfaceType == null)
            {
                return NotFound();
            }

            return View(surfaceType);
        }

        // POST: SurfaceType/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> DeleteConfirmed(int id)
        {
            var surfaceType = await _context.SurfaceType.SingleOrDefaultAsync(m => m.SurfaceTypeId == id);
            _context.SurfaceType.Remove(surfaceType);
            await _context.SaveChangesAsync();
            return RedirectToAction("Index");
        }

        private bool SurfaceTypeExists(int id)
        {
            return _context.SurfaceType.Any(e => e.SurfaceTypeId == id);
        }
    }
}
