using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.Rendering;
using Microsoft.EntityFrameworkCore;
using Maps.Entities;

namespace maps_core.Controllers
{
    public class StateCommonController : Controller
    {
        private readonly PostgresDbContext _context;

        public StateCommonController(PostgresDbContext context)
        {
            _context = context;    
        }

        // GET: StateCommon
        public async Task<IActionResult> Index()
        {
            return View(await _context.StateCommon.ToListAsync());
        }

        // GET: StateCommon/Details/5
        public async Task<IActionResult> Details(int? id)
        {
            if (id == null)
            {
                return NotFound();
            }

            var stateCommon = await _context.StateCommon.SingleOrDefaultAsync(m => m.StateCommonId == id);
            if (stateCommon == null)
            {
                return NotFound();
            }

            return View(stateCommon);
        }

        // GET: StateCommon/Create
        public IActionResult Create()
        {
            return View();
        }

        // POST: StateCommon/Create
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> Create([Bind("StateCommonId,Value")] StateCommon stateCommon)
        {
            if (ModelState.IsValid)
            {
                _context.Add(stateCommon);
                await _context.SaveChangesAsync();
                return RedirectToAction("Index");
            }
            return View(stateCommon);
        }

        // GET: StateCommon/Edit/5
        public async Task<IActionResult> Edit(int? id)
        {
            if (id == null)
            {
                return NotFound();
            }

            var stateCommon = await _context.StateCommon.SingleOrDefaultAsync(m => m.StateCommonId == id);
            if (stateCommon == null)
            {
                return NotFound();
            }
            return View(stateCommon);
        }

        // POST: StateCommon/Edit/5
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> Edit(int id, [Bind("StateCommonId,Value")] StateCommon stateCommon)
        {
            if (id != stateCommon.StateCommonId)
            {
                return NotFound();
            }

            if (ModelState.IsValid)
            {
                try
                {
                    _context.Update(stateCommon);
                    await _context.SaveChangesAsync();
                }
                catch (DbUpdateConcurrencyException)
                {
                    if (!StateCommonExists(stateCommon.StateCommonId))
                    {
                        return NotFound();
                    }
                    else
                    {
                        throw;
                    }
                }
                return RedirectToAction("Index");
            }
            return View(stateCommon);
        }

        // GET: StateCommon/Delete/5
        public async Task<IActionResult> Delete(int? id)
        {
            if (id == null)
            {
                return NotFound();
            }

            var stateCommon = await _context.StateCommon.SingleOrDefaultAsync(m => m.StateCommonId == id);
            if (stateCommon == null)
            {
                return NotFound();
            }

            return View(stateCommon);
        }

        // POST: StateCommon/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> DeleteConfirmed(int id)
        {
            var stateCommon = await _context.StateCommon.SingleOrDefaultAsync(m => m.StateCommonId == id);
            _context.StateCommon.Remove(stateCommon);
            await _context.SaveChangesAsync();
            return RedirectToAction("Index");
        }

        private bool StateCommonExists(int id)
        {
            return _context.StateCommon.Any(e => e.StateCommonId == id);
        }
    }
}
