using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.Rendering;
using Microsoft.EntityFrameworkCore;
using Maps.Entities;

namespace maps_core.Controllers
{
    public class SettlementController : Controller
    {
        private readonly PostgresDbContext _context;

        public SettlementController(PostgresDbContext context)
        {
            _context = context;    
        }

        // GET: Settlement
        public async Task<IActionResult> Index()
        {
            return View(await _context.Settlement.ToListAsync());
        }

        // GET: Settlement/Details/5
        public async Task<IActionResult> Details(int? id)
        {
            if (id == null)
            {
                return NotFound();
            }

            var settlement = await _context.Settlement.SingleOrDefaultAsync(m => m.SettlementId == id);
            if (settlement == null)
            {
                return NotFound();
            }

            return View(settlement);
        }

        // GET: Settlement/Create
        public IActionResult Create()
        {
            return View();
        }

        // POST: Settlement/Create
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> Create([Bind("SettlementId,Name,Sign")] Settlement settlement)
        {
            if (ModelState.IsValid)
            {
                _context.Add(settlement);
                await _context.SaveChangesAsync();
                return RedirectToAction("Index");
            }
            return View(settlement);
        }

        // GET: Settlement/Edit/5
        public async Task<IActionResult> Edit(int? id)
        {
            if (id == null)
            {
                return NotFound();
            }

            var settlement = await _context.Settlement.SingleOrDefaultAsync(m => m.SettlementId == id);
            if (settlement == null)
            {
                return NotFound();
            }
            return View(settlement);
        }

        // POST: Settlement/Edit/5
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> Edit(int id, [Bind("SettlementId,Name,Sign")] Settlement settlement)
        {
            if (id != settlement.SettlementId)
            {
                return NotFound();
            }

            if (ModelState.IsValid)
            {
                try
                {
                    _context.Update(settlement);
                    await _context.SaveChangesAsync();
                }
                catch (DbUpdateConcurrencyException)
                {
                    if (!SettlementExists(settlement.SettlementId))
                    {
                        return NotFound();
                    }
                    else
                    {
                        throw;
                    }
                }
                return RedirectToAction("Index");
            }
            return View(settlement);
        }

        // GET: Settlement/Delete/5
        public async Task<IActionResult> Delete(int? id)
        {
            if (id == null)
            {
                return NotFound();
            }

            var settlement = await _context.Settlement.SingleOrDefaultAsync(m => m.SettlementId == id);
            if (settlement == null)
            {
                return NotFound();
            }

            return View(settlement);
        }

        // POST: Settlement/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> DeleteConfirmed(int id)
        {
            var settlement = await _context.Settlement.SingleOrDefaultAsync(m => m.SettlementId == id);
            _context.Settlement.Remove(settlement);
            await _context.SaveChangesAsync();
            return RedirectToAction("Index");
        }

        private bool SettlementExists(int id)
        {
            return _context.Settlement.Any(e => e.SettlementId == id);
        }
    }
}
